/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

public final class ArrayCache
implements MarlinConst {
    static final int BUCKETS = 4;
    static final int MIN_ARRAY_SIZE = 4096;
    static final int MAX_ARRAY_SIZE;
    static final int MASK_CLR_1 = -2;
    static final int THRESHOLD_ARRAY_SIZE;
    static final int[] ARRAY_SIZES;
    static final int MIN_DIRTY_BYTE_ARRAY_SIZE = 65536;
    static final int MAX_DIRTY_BYTE_ARRAY_SIZE;
    static final int[] DIRTY_BYTE_ARRAY_SIZES;
    static final long THRESHOLD_LARGE_ARRAY_SIZE;
    static final long THRESHOLD_HUGE_ARRAY_SIZE;
    private static int resizeInt;
    private static int resizeDirtyInt;
    private static int resizeDirtyFloat;
    private static int resizeDirtyByte;
    private static int oversize;

    private ArrayCache() {
    }

    static synchronized void incResizeInt() {
        ++resizeInt;
    }

    static synchronized void incResizeDirtyInt() {
        ++resizeDirtyInt;
    }

    static synchronized void incResizeDirtyFloat() {
        ++resizeDirtyFloat;
    }

    static synchronized void incResizeDirtyByte() {
        ++resizeDirtyByte;
    }

    static synchronized void incOversize() {
        ++oversize;
    }

    static void dumpStats() {
        if (resizeInt != 0 || resizeDirtyInt != 0 || resizeDirtyFloat != 0 || resizeDirtyByte != 0 || oversize != 0) {
            MarlinUtils.logInfo("ArrayCache: int resize: " + resizeInt + " - dirty int resize: " + resizeDirtyInt + " - dirty float resize: " + resizeDirtyFloat + " - dirty byte resize: " + resizeDirtyByte + " - oversize: " + oversize);
        }
    }

    static int getBucket(int length) {
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            if (length > ARRAY_SIZES[i]) continue;
            return i;
        }
        return -1;
    }

    static int getBucketDirtyBytes(int length) {
        for (int i = 0; i < DIRTY_BYTE_ARRAY_SIZES.length; ++i) {
            if (length > DIRTY_BYTE_ARRAY_SIZES[i]) continue;
            return i;
        }
        return -1;
    }

    public static int getNewSize(int curSize, int needSize) {
        if (needSize < 0) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (curSize >= 0);
        int initial = curSize & 0xFFFFFFFE;
        int size = initial > THRESHOLD_ARRAY_SIZE ? initial + (initial >> 1) : initial << 1;
        if (size < needSize) {
            size = (needSize >> 12) + 1 << 12;
        }
        if (size < 0) {
            size = Integer.MAX_VALUE;
        }
        return size;
    }

    public static long getNewLargeSize(long curSize, long needSize) {
        if (needSize >> 31 != 0L) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (curSize >= 0L);
        long size = curSize > THRESHOLD_HUGE_ARRAY_SIZE ? curSize + (curSize >> 2) : (curSize > THRESHOLD_LARGE_ARRAY_SIZE ? curSize + (curSize >> 1) : curSize << 1);
        if (size < needSize) {
            size = (needSize >> 12) + 1L << 12;
        }
        if (size > Integer.MAX_VALUE) {
            size = Integer.MAX_VALUE;
        }
        return size;
    }

    static {
        ARRAY_SIZES = new int[4];
        DIRTY_BYTE_ARRAY_SIZES = new int[4];
        resizeInt = 0;
        resizeDirtyInt = 0;
        resizeDirtyFloat = 0;
        resizeDirtyByte = 0;
        oversize = 0;
        int arraySize = 4096;
        int i = 0;
        while (i < 4) {
            ArrayCache.ARRAY_SIZES[i] = arraySize;
            if (doTrace) {
                MarlinUtils.logInfo("arraySize[" + i + "]: " + arraySize);
            }
            ++i;
            arraySize <<= 2;
        }
        MAX_ARRAY_SIZE = arraySize >> 2;
        arraySize = 65536;
        i = 0;
        while (i < 4) {
            ArrayCache.DIRTY_BYTE_ARRAY_SIZES[i] = arraySize;
            if (doTrace) {
                MarlinUtils.logInfo("dirty arraySize[" + i + "]: " + arraySize);
            }
            ++i;
            arraySize <<= 1;
        }
        MAX_DIRTY_BYTE_ARRAY_SIZE = arraySize >> 1;
        THRESHOLD_ARRAY_SIZE = Math.max(0x200000, MAX_ARRAY_SIZE);
        THRESHOLD_LARGE_ARRAY_SIZE = 8L * (long)THRESHOLD_ARRAY_SIZE;
        THRESHOLD_HUGE_ARRAY_SIZE = 8L * THRESHOLD_LARGE_ARRAY_SIZE;
        if (doStats) {
            MarlinUtils.logInfo("ArrayCache.BUCKETS        = 4");
            MarlinUtils.logInfo("ArrayCache.MIN_ARRAY_SIZE = 4096");
            MarlinUtils.logInfo("ArrayCache.MAX_ARRAY_SIZE = " + MAX_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.MIN_DIRTY_BYTE_ARRAY_SIZE = 65536");
            MarlinUtils.logInfo("ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE = " + MAX_DIRTY_BYTE_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(DIRTY_BYTE_ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_ARRAY_SIZE = " + THRESHOLD_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_LARGE_ARRAY_SIZE = " + THRESHOLD_LARGE_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_HUGE_ARRAY_SIZE = " + THRESHOLD_HUGE_ARRAY_SIZE);
        }
    }
}

