/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class ByteArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<byte[]> byteArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("ByteArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.byteArrays.size());
        }
    }

    ByteArrayCache(int arraySize) {
        this.arraySize = arraySize;
        this.byteArrays = new ArrayDeque(6);
    }

    byte[] getArray() {
        byte[] array;
        if (doStats) {
            ++this.getOp;
        }
        if ((array = this.byteArrays.pollLast()) != null) {
            return array;
        }
        if (doStats) {
            ++this.createOp;
        }
        return new byte[this.arraySize];
    }

    void putDirtyArray(byte[] array, int length) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        this.byteArrays.addLast(array);
    }

    void putArray(byte[] array, int length, int fromIndex, int toIndex) {
        if (length != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + length);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        ByteArrayCache.fill(array, fromIndex, toIndex, (byte)0);
        this.byteArrays.addLast(array);
    }

    static void fill(byte[] array, int fromIndex, int toIndex, byte value) {
        if (toIndex != 0) {
            Arrays.fill(array, fromIndex, toIndex, value);
        }
        if (doChecks) {
            ByteArrayCache.check(array, fromIndex, toIndex, value);
        }
    }

    static void check(byte[] array, int fromIndex, int toIndex, byte value) {
        if (doChecks) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + array[i] + " from: " + fromIndex + " to: " + toIndex + "\n" + Arrays.toString(array), new Throwable());
                Arrays.fill(array, value);
                return;
            }
        }
    }
}

