/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Composite;
import java.lang.ref.WeakReference;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;

final class OGLSurfaceToSwBlit
extends Blit {
    private final int typeval;
    private WeakReference<SurfaceData> srcTmp;

    OGLSurfaceToSwBlit(SurfaceType dstType, int typeval) {
        super(OGLSurfaceData.OpenGLSurface, CompositeType.SrcNoEa, dstType);
        this.typeval = typeval;
    }

    private synchronized void complexClipBlit(SurfaceData src, SurfaceData dst, Composite comp, Region clip, int sx, int sy, int dx, int dy, int w, int h) {
        SurfaceData cachedSrc = null;
        if (this.srcTmp != null) {
            cachedSrc = (SurfaceData)this.srcTmp.get();
        }
        int type = this.typeval == 1 ? 3 : 2;
        src = OGLSurfaceToSwBlit.convertFrom(this, src, sx, sy, w, h, cachedSrc, type);
        Blit performop = Blit.getFromCache(src.getSurfaceType(), CompositeType.SrcNoEa, dst.getSurfaceType());
        performop.Blit(src, dst, comp, clip, 0, 0, dx, dy, w, h);
        if (src != cachedSrc) {
            this.srcTmp = new WeakReference<SurfaceData>(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Blit(SurfaceData src, SurfaceData dst, Composite comp, Region clip, int sx, int sy, int dx, int dy, int w, int h) {
        if (clip != null) {
            if ((clip = clip.getIntersectionXYWH(dx, dy, w, h)).isEmpty()) {
                return;
            }
            sx += clip.getLoX() - dx;
            sy += clip.getLoY() - dy;
            dx = clip.getLoX();
            dy = clip.getLoY();
            w = clip.getWidth();
            h = clip.getHeight();
            if (!clip.isRectangular()) {
                this.complexClipBlit(src, dst, comp, clip, sx, sy, dx, dy, w, h);
                return;
            }
        }
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            rq.addReference(dst);
            RenderBuffer buf = rq.getBuffer();
            OGLContext.validateContext((OGLSurfaceData)src);
            rq.ensureCapacityAndAlignment(48, 32);
            buf.putInt(34);
            buf.putInt(sx).putInt(sy);
            buf.putInt(dx).putInt(dy);
            buf.putInt(w).putInt(h);
            buf.putInt(this.typeval);
            buf.putLong(src.getNativeOps());
            buf.putLong(dst.getNativeOps());
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }
}

