/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import sun.misc.ObjectInputFilter;
import sun.rmi.registry.RegistryImpl;

public class SingleEntryRegistry
extends RegistryImpl {
    private final String name;
    private final Remote object;
    private static final long serialVersionUID = -4897238949499730950L;

    SingleEntryRegistry(int port, String name, Remote object) throws RemoteException {
        super(port, null, null, SingleEntryRegistry::singleRegistryFilter);
        this.name = name;
        this.object = object;
    }

    SingleEntryRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, String name, Remote object) throws RemoteException {
        super(port, csf, ssf, SingleEntryRegistry::singleRegistryFilter);
        this.name = name;
        this.object = object;
    }

    @Override
    public String[] list() {
        return new String[]{this.name};
    }

    @Override
    public Remote lookup(String name) throws NotBoundException {
        if (name.equals(this.name)) {
            return this.object;
        }
        throw new NotBoundException("Not bound: \"" + name + "\" (only bound name is \"" + this.name + "\")");
    }

    @Override
    public void bind(String name, Remote obj) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    @Override
    public void rebind(String name, Remote obj) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    @Override
    public void unbind(String name) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    private static ObjectInputFilter.Status singleRegistryFilter(ObjectInputFilter.FilterInfo info) {
        return info.serialClass() != null || info.depth() > 2L || info.references() > 4L || info.arrayLength() >= 0L ? ObjectInputFilter.Status.REJECTED : ObjectInputFilter.Status.ALLOWED;
    }
}

