/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncKrbCredPart;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBCred;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbCredInfo;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.util.DerValue;

public class KrbCred {
    private static boolean DEBUG = Krb5.DEBUG;
    private byte[] obuf = null;
    private KRBCred credMessg = null;
    private Ticket ticket = null;
    private EncKrbCredPart encPart = null;
    private Credentials creds = null;
    private KerberosTime timeStamp = null;

    public KrbCred(Credentials tgt, Credentials serviceTicket, EncryptionKey key) throws KrbException, IOException {
        PrincipalName client = tgt.getClient();
        PrincipalName tgService = tgt.getServer();
        if (!serviceTicket.getClient().equals(client)) {
            throw new KrbException(60, "Client principal does not match");
        }
        KDCOptions options = new KDCOptions();
        options.set(2, true);
        options.set(1, true);
        KrbTgsReq tgsReq = new KrbTgsReq(options, tgt, tgService, null, null, null, null, null, null, null, null, null);
        this.credMessg = this.createMessage(tgsReq.sendAndGetCreds(), key);
        this.obuf = this.credMessg.asn1Encode();
    }

    KRBCred createMessage(Credentials delegatedCreds, EncryptionKey key) throws KrbException, IOException {
        EncryptionKey sessionKey = delegatedCreds.getSessionKey();
        PrincipalName princ = delegatedCreds.getClient();
        PrincipalName tgService = delegatedCreds.getServer();
        KrbCredInfo credInfo = new KrbCredInfo(sessionKey, princ, delegatedCreds.flags, delegatedCreds.authTime, delegatedCreds.startTime, delegatedCreds.endTime, delegatedCreds.renewTill, tgService, delegatedCreds.cAddr);
        this.timeStamp = KerberosTime.now();
        KrbCredInfo[] credInfos = new KrbCredInfo[]{credInfo};
        EncKrbCredPart encPart = new EncKrbCredPart(credInfos, this.timeStamp, null, null, null, null);
        EncryptedData encEncPart = new EncryptedData(key, encPart.asn1Encode(), 14);
        Ticket[] tickets = new Ticket[]{delegatedCreds.ticket};
        this.credMessg = new KRBCred(tickets, encEncPart);
        return this.credMessg;
    }

    public KrbCred(byte[] asn1Message, EncryptionKey key) throws KrbException, IOException {
        this.credMessg = new KRBCred(asn1Message);
        this.ticket = this.credMessg.tickets[0];
        if (this.credMessg.encPart.getEType() == 0) {
            key = EncryptionKey.NULL_KEY;
        }
        byte[] temp = this.credMessg.encPart.decrypt(key, 14);
        byte[] plainText = this.credMessg.encPart.reset(temp);
        DerValue encoding = new DerValue(plainText);
        EncKrbCredPart encPart = new EncKrbCredPart(encoding);
        this.timeStamp = encPart.timeStamp;
        KrbCredInfo credInfo = encPart.ticketInfo[0];
        EncryptionKey credInfoKey = credInfo.key;
        PrincipalName pname = credInfo.pname;
        TicketFlags flags = credInfo.flags;
        KerberosTime authtime = credInfo.authtime;
        KerberosTime starttime = credInfo.starttime;
        KerberosTime endtime = credInfo.endtime;
        KerberosTime renewTill = credInfo.renewTill;
        PrincipalName sname = credInfo.sname;
        HostAddresses caddr = credInfo.caddr;
        if (DEBUG) {
            System.out.println(">>>Delegated Creds have pname=" + pname + " sname=" + sname + " authtime=" + authtime + " starttime=" + starttime + " endtime=" + endtime + "renewTill=" + renewTill);
        }
        this.creds = new Credentials(this.ticket, pname, null, sname, null, credInfoKey, flags, authtime, starttime, endtime, renewTill, caddr);
    }

    public Credentials[] getDelegatedCreds() {
        Credentials[] allCreds = new Credentials[]{this.creds};
        return allCreds;
    }

    public byte[] getMessage() {
        return this.obuf;
    }
}

