/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Optional;
import sun.security.ec.ECDSAOperations;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECOperations;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.jca.JCAUtil;
import sun.security.util.ECUtil;

abstract class ECDSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private SecureRandom random;
    private boolean needsReset;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private ECParameterSpec sigParams = null;

    ECDSASignature() {
        this.messageDigest = null;
    }

    ECDSASignature(String digestName) {
        try {
            this.messageDigest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKey key = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        if (!ECDSASignature.isCompatible(this.sigParams, key.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.publicKey = key;
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        ECPrivateKey key = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        if (!ECDSASignature.isCompatible(this.sigParams, key.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.privateKey = key;
        this.publicKey = null;
        this.random = random;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    private static boolean isCompatible(ECParameterSpec sigParams, ECParameterSpec keyParams) {
        if (sigParams == null) {
            return true;
        }
        return ECUtil.equals(sigParams, keyParams);
    }

    private byte[] signDigestImpl(ECDSAOperations ops, int seedBits, byte[] digest, ECPrivateKeyImpl privImpl, SecureRandom random) throws SignatureException {
        byte[] seedBytes = new byte[(seedBits + 7) / 8];
        byte[] s = privImpl.getArrayS();
        int numAttempts = 128;
        for (int i = 0; i < numAttempts; ++i) {
            random.nextBytes(seedBytes);
            ECDSAOperations.Seed seed = new ECDSAOperations.Seed(seedBytes);
            try {
                return ops.signDigest(s, digest, seed);
            }
            catch (ECOperations.IntermediateValueException intermediateValueException) {
                continue;
            }
        }
        throw new SignatureException("Unable to produce signature after " + numAttempts + " attempts");
    }

    private Optional<byte[]> signDigestImpl(ECPrivateKey privateKey, byte[] digest, SecureRandom random) throws SignatureException {
        if (!(privateKey instanceof ECPrivateKeyImpl)) {
            return Optional.empty();
        }
        ECPrivateKeyImpl privImpl = (ECPrivateKeyImpl)privateKey;
        ECParameterSpec params = privateKey.getParams();
        int seedBits = params.getOrder().bitLength() + 64;
        Optional<ECDSAOperations> opsOpt = ECDSAOperations.forParameters(params);
        if (!opsOpt.isPresent()) {
            return Optional.empty();
        }
        byte[] sig = this.signDigestImpl(opsOpt.get(), seedBits, digest, privImpl, random);
        return Optional.of(sig);
    }

    private byte[] signDigestNative(ECPrivateKey privateKey, byte[] digest, SecureRandom random) throws SignatureException {
        byte[] s = privateKey.getS().toByteArray();
        ECParameterSpec params = privateKey.getParams();
        byte[] encodedParams = ECUtil.encodeECParameterSpec(null, params);
        int orderLength = params.getOrder().bitLength();
        byte[] seed = new byte[((orderLength + 7 >> 3) + 1) * 2];
        random.nextBytes(seed);
        int timingArgument = random.nextInt();
        timingArgument |= 1;
        try {
            return ECDSASignature.signDigest(digest, s, encodedParams, seed, timingArgument);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Could not sign data", e);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] digest;
        Optional<byte[]> sigOpt;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        byte[] sig = (sigOpt = this.signDigestImpl(this.privateKey, digest = this.getDigestValue(), this.random)).isPresent() ? sigOpt.get() : this.signDigestNative(this.privateKey, digest, this.random);
        return ECUtil.encodeSignature(sig);
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        ECParameterSpec params = this.publicKey.getParams();
        byte[] encodedParams = ECUtil.encodeECParameterSpec(null, params);
        byte[] w = this.publicKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)this.publicKey).getEncodedPublicValue() : ECUtil.encodePoint(this.publicKey.getW(), params.getCurve());
        try {
            return ECDSASignature.verifySignedDigest(ECUtil.decodeSignature(signature), this.getDigestValue(), w, encodedParams);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Could not verify signature", e);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        Key key;
        if (params != null && !(params instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
        Key key2 = key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (key != null && !ECDSASignature.isCompatible((ECParameterSpec)params, key.getParams())) {
            throw new InvalidAlgorithmParameterException("Signature params does not match key params");
        }
        this.sigParams = (ECParameterSpec)params;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams == null) {
            return null;
        }
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("EC");
            ap.init(this.sigParams);
            return ap;
        }
        catch (Exception e) {
            throw new ProviderException("Error retrieving EC parameters", e);
        }
    }

    private static native byte[] signDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4) throws GeneralSecurityException;

    private static native boolean verifySignedDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224
    extends ECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class Raw
    extends ECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = b;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(b, off, this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (this.offset + len >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] result = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, result, 0, this.offset);
            this.offset = 0;
            return result;
        }
    }
}

