/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.EventSettings;
import jdk.jfr.FlightRecorder;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

public final class Recording
implements Closeable {
    private final PlatformRecording internal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recording(Map<String, String> settings) {
        PlatformRecorder r;
        PlatformRecorder platformRecorder = r = FlightRecorder.getFlightRecorder().getInternal();
        synchronized (platformRecorder) {
            this.internal = r.newRecording(settings);
            this.internal.setRecording(this);
            if (this.internal.getRecording() != this) {
                throw new InternalError("Internal recording not properly setup");
            }
        }
    }

    public Recording() {
        this(new HashMap<String, String>());
    }

    public Recording(Configuration configuration) {
        this(configuration.getSettings());
    }

    public void start() {
        this.internal.start();
    }

    public void scheduleStart(Duration delay) {
        Objects.requireNonNull(delay);
        this.internal.scheduleStart(delay);
    }

    public boolean stop() {
        return this.internal.stop("Stopped by user");
    }

    public Map<String, String> getSettings() {
        return new HashMap<String, String>(this.internal.getSettings());
    }

    public long getSize() {
        return this.internal.getSize();
    }

    public Instant getStopTime() {
        return this.internal.getStopTime();
    }

    public Instant getStartTime() {
        return this.internal.getStartTime();
    }

    public long getMaxSize() {
        return this.internal.getMaxSize();
    }

    public Duration getMaxAge() {
        return this.internal.getMaxAge();
    }

    public String getName() {
        return this.internal.getName();
    }

    public void setSettings(Map<String, String> settings) {
        Objects.requireNonNull(settings);
        Map<String, String> sanitized = Utils.sanitizeNullFreeStringMap(settings);
        this.internal.setSettings(sanitized);
    }

    public RecordingState getState() {
        return this.internal.getState();
    }

    @Override
    public void close() {
        this.internal.close();
    }

    public Recording copy(boolean stop) {
        return this.internal.newCopy(stop);
    }

    public void dump(Path destination) throws IOException {
        Objects.requireNonNull(destination);
        this.internal.dump(new WriteableUserPath(destination));
    }

    public boolean isToDisk() {
        return this.internal.isToDisk();
    }

    public void setMaxSize(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("Max size of recording can't be negative");
        }
        this.internal.setMaxSize(maxSize);
    }

    public void setMaxAge(Duration maxAge) {
        if (maxAge != null && maxAge.isNegative()) {
            throw new IllegalArgumentException("Max age of recording can't be negative");
        }
        this.internal.setMaxAge(maxAge);
    }

    public void setDestination(Path destination) throws IOException {
        this.internal.setDestination(destination != null ? new WriteableUserPath(destination) : null);
    }

    public Path getDestination() {
        WriteableUserPath usp = this.internal.getDestination();
        if (usp == null) {
            return null;
        }
        return usp.getPotentiallyMaliciousOriginal();
    }

    public long getId() {
        return this.internal.getId();
    }

    public void setName(String name) {
        Objects.requireNonNull(name);
        this.internal.setName(name);
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.internal.setDumpOnExit(dumpOnExit);
    }

    public boolean getDumpOnExit() {
        return this.internal.getDumpOnExit();
    }

    public void setToDisk(boolean disk) {
        this.internal.setToDisk(disk);
    }

    public InputStream getStream(Instant start, Instant end) throws IOException {
        if (start != null && end != null && end.isBefore(start)) {
            throw new IllegalArgumentException("End time of requested stream must not be before start time");
        }
        return this.internal.open(start, end);
    }

    public Duration getDuration() {
        return this.internal.getDuration();
    }

    public void setDuration(Duration duration) {
        this.internal.setDuration(duration);
    }

    public EventSettings enable(String name) {
        Objects.requireNonNull(name);
        RecordingSettings rs = new RecordingSettings(this, name);
        rs.with("enabled", "true");
        return rs;
    }

    public EventSettings disable(String name) {
        Objects.requireNonNull(name);
        RecordingSettings rs = new RecordingSettings(this, name);
        rs.with("enabled", "false");
        return rs;
    }

    public EventSettings enable(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        RecordingSettings rs = new RecordingSettings(this, eventClass);
        rs.with("enabled", "true");
        return rs;
    }

    public EventSettings disable(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        RecordingSettings rs = new RecordingSettings(this, eventClass);
        rs.with("enabled", "false");
        return rs;
    }

    PlatformRecording getInternal() {
        return this.internal;
    }

    private void setSetting(String id, String value) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(value);
        this.internal.setSetting(id, value);
    }

    private static class RecordingSettings
    extends EventSettings {
        private final Recording recording;
        private final String identifier;

        RecordingSettings(Recording r, String identifier) {
            this.recording = r;
            this.identifier = identifier;
        }

        RecordingSettings(Recording r, Class<? extends Event> eventClass) {
            Utils.ensureValidEventSubclass(eventClass);
            this.recording = r;
            this.identifier = String.valueOf(Type.getTypeId(eventClass));
        }

        @Override
        public EventSettings with(String name, String value) {
            Objects.requireNonNull(value);
            this.recording.setSetting(this.identifier + "#" + name, value);
            return this;
        }

        @Override
        public Map<String, String> toMap() {
            return this.recording.getSettings();
        }
    }
}

