/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.ContentType;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.Type;

public final class SettingDescriptor {
    private final AnnotationConstruct annotationConstruct;
    private final Type type;
    private final String name;
    private final String defaultValue;

    SettingDescriptor(Type type, String name, String defaultValue, List<AnnotationElement> annotations) {
        Objects.requireNonNull(annotations);
        this.name = Objects.requireNonNull(name, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(type);
        this.annotationConstruct = new AnnotationConstruct(annotations);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    void setAnnotations(List<AnnotationElement> as) {
        this.annotationConstruct.setAnnotationElements(as);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        String label = this.annotationConstruct.getLabel();
        if (label == null) {
            label = this.type.getLabel();
        }
        return label;
    }

    public String getDescription() {
        String description = this.annotationConstruct.getDescription();
        if (description == null) {
            description = this.type.getDescription();
        }
        return description;
    }

    public String getContentType() {
        for (AnnotationElement anno : this.getAnnotationElements()) {
            for (AnnotationElement meta : anno.getAnnotationElements()) {
                if (!meta.getTypeName().equals(ContentType.class.getName())) continue;
                return anno.getTypeName();
            }
        }
        for (AnnotationElement anno : this.type.getAnnotationElements()) {
            for (AnnotationElement meta : anno.getAnnotationElements()) {
                if (!meta.getTypeName().equals(ContentType.class.getName())) continue;
                return anno.getTypeName();
            }
        }
        return null;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public long getTypeId() {
        return this.type.getId();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Objects.requireNonNull(annotationType);
        return (A)((Annotation)this.annotationConstruct.getAnnotation(annotationType));
    }

    public List<AnnotationElement> getAnnotationElements() {
        return Collections.unmodifiableList(this.annotationConstruct.getUnmodifiableAnnotationElements());
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    Type getType() {
        return this.type;
    }
}

