/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.ContentType;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class ValueDescriptor {
    private final AnnotationConstruct annotationConstruct;
    private final Type type;
    private final String name;
    private final boolean isArray;
    private final boolean constantPool;
    private final String javaFieldName;

    ValueDescriptor(Type type, String name, List<AnnotationElement> annotations, int dimension, boolean constantPool, String fieldName) {
        Objects.requireNonNull(annotations);
        if (dimension < 0) {
            throw new IllegalArgumentException("Dimension must be positive");
        }
        this.name = Objects.requireNonNull(name, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(type);
        this.isArray = dimension > 0;
        this.constantPool = constantPool;
        this.annotationConstruct = new AnnotationConstruct(annotations);
        this.javaFieldName = fieldName;
    }

    public ValueDescriptor(Class<?> type, String name) {
        this(type, name, Collections.emptyList());
    }

    public ValueDescriptor(Class<?> type, String name, List<AnnotationElement> annotations) {
        this(type, name, new ArrayList<AnnotationElement>(annotations), false);
    }

    ValueDescriptor(Class<?> type, String name, List<AnnotationElement> annotations, boolean allowArray) {
        Objects.requireNonNull(annotations);
        Utils.checkRegisterPermission();
        if (!allowArray && type.isArray()) {
            throw new IllegalArgumentException("Array types are not allowed");
        }
        this.name = Objects.requireNonNull(name, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(Utils.getValidType(Objects.requireNonNull(type), Objects.requireNonNull(name)));
        this.annotationConstruct = new AnnotationConstruct(annotations);
        this.javaFieldName = name;
        this.isArray = type.isArray();
        this.constantPool = type == Class.class || type == Thread.class;
    }

    public String getLabel() {
        return this.annotationConstruct.getLabel();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.annotationConstruct.getDescription();
    }

    public String getContentType() {
        for (AnnotationElement anno : this.getAnnotationElements()) {
            for (AnnotationElement meta : anno.getAnnotationElements()) {
                if (!meta.getTypeName().equals(ContentType.class.getName())) continue;
                return anno.getTypeName();
            }
        }
        return null;
    }

    public String getTypeName() {
        if (this.type.isSimpleType()) {
            return this.type.getFields().get(0).getTypeName();
        }
        return this.type.getName();
    }

    public long getTypeId() {
        return this.type.getId();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Objects.requireNonNull(annotationType);
        return (A)((Annotation)this.annotationConstruct.getAnnotation(annotationType));
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.annotationConstruct.getUnmodifiableAnnotationElements();
    }

    public List<ValueDescriptor> getFields() {
        if (this.type.isSimpleType()) {
            return Collections.emptyList();
        }
        return this.type.getFields();
    }

    Type getType() {
        return this.type;
    }

    void setAnnotations(List<AnnotationElement> anno) {
        this.annotationConstruct.setAnnotationElements(anno);
    }

    boolean isConstantPool() {
        return this.constantPool;
    }

    String getJavaFieldName() {
        return this.javaFieldName;
    }

    boolean isUnsigned() {
        return this.annotationConstruct.hasUnsigned();
    }
}

