/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.util.ArrayList;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;

final class ConstantMap {
    private final ObjectFactory<?> factory;
    private final LongMap<Object> objects;
    private LongMap<Boolean> isResolving;
    private boolean allResolved;
    private String name;

    ConstantMap(ObjectFactory<?> factory, String name) {
        this.name = name;
        this.objects = new LongMap();
        this.factory = factory;
    }

    Object get(long id) {
        if (this.allResolved) {
            return this.objects.get(id);
        }
        if (this.isResolving == null) {
            return new Reference(this, id);
        }
        Boolean beingResolved = this.isResolving.get(id);
        if (Boolean.FALSE.equals(beingResolved)) {
            return this.objects.get(id);
        }
        if (Boolean.TRUE.equals(beingResolved)) {
            return null;
        }
        this.isResolving.put(id, Boolean.TRUE);
        Object resolved = ConstantMap.resolve(this.objects.get(id));
        this.isResolving.put(id, Boolean.FALSE);
        if (this.factory != null) {
            Object factorized = this.factory.createObject(id, resolved);
            this.objects.put(id, factorized);
            return factorized;
        }
        this.objects.put(id, resolved);
        return resolved;
    }

    private static Object resolve(Object o) {
        if (o instanceof Reference) {
            return ConstantMap.resolve(((Reference)o).resolve());
        }
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            for (int i = 0; i < array.length; ++i) {
                array[i] = ConstantMap.resolve(array[i]);
            }
            return array;
        }
        return o;
    }

    public void resolve() {
        ArrayList keyList = new ArrayList();
        this.objects.keys().forEachRemaining(keyList::add);
        for (Long l : keyList) {
            this.get(l);
        }
    }

    public void put(long key, Object value) {
        this.objects.put(key, value);
    }

    public void setIsResolving() {
        this.isResolving = new LongMap();
    }

    public void setResolved() {
        this.allResolved = true;
        this.isResolving = null;
    }

    public String getName() {
        return this.name;
    }

    private static final class Reference {
        private final long key;
        private final ConstantMap pool;

        Reference(ConstantMap pool, long key) {
            this.pool = pool;
            this.key = key;
        }

        Object resolve() {
            return this.pool.get(this.key);
        }
    }
}

