/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.consumer.ChunkParser;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;
import jdk.jfr.internal.consumer.RecordingInternals;

public final class RecordingFile
implements Closeable {
    private boolean isLastEventInChunk;
    private final File file;
    private RecordingInput input;
    private ChunkParser chunkParser;
    private RecordedEvent nextEvent;
    private boolean eof;

    public RecordingFile(Path file) throws IOException {
        this.file = file.toFile();
        this.input = new RecordingInput(this.file);
        this.findNext();
    }

    public RecordedEvent readEvent() throws IOException {
        if (this.eof) {
            this.ensureOpen();
            throw new EOFException();
        }
        this.isLastEventInChunk = false;
        RecordedEvent event = this.nextEvent;
        this.nextEvent = this.chunkParser.readEvent();
        if (this.nextEvent == null) {
            this.isLastEventInChunk = true;
            this.findNext();
        }
        return event;
    }

    public boolean hasMoreEvents() {
        return !this.eof;
    }

    public List<EventType> readEventTypes() throws IOException {
        this.ensureOpen();
        ArrayList<EventType> types = new ArrayList<EventType>();
        HashSet<Long> foundIds = new HashSet<Long>();
        try (RecordingInput ri = new RecordingInput(this.file);){
            ChunkHeader ch = new ChunkHeader(ri);
            RecordingFile.aggregateEventTypeForChunk(ch, types, foundIds);
            while (!ch.isLastChunk()) {
                ch = ch.nextHeader();
                RecordingFile.aggregateEventTypeForChunk(ch, types, foundIds);
            }
        }
        return types;
    }

    List<Type> readTypes() throws IOException {
        this.ensureOpen();
        ArrayList<Type> types = new ArrayList<Type>();
        HashSet<Long> foundIds = new HashSet<Long>();
        try (RecordingInput ri = new RecordingInput(this.file);){
            ChunkHeader ch = new ChunkHeader(ri);
            this.aggregateTypeForChunk(ch, types, foundIds);
            while (!ch.isLastChunk()) {
                ch = ch.nextHeader();
                this.aggregateTypeForChunk(ch, types, foundIds);
            }
        }
        return types;
    }

    private void aggregateTypeForChunk(ChunkHeader ch, List<Type> types, HashSet<Long> foundIds) throws IOException {
        MetadataDescriptor m = ch.readMetadata();
        for (Type t : m.getTypes()) {
            if (foundIds.contains(t.getId())) continue;
            types.add(t);
            foundIds.add(t.getId());
        }
    }

    private static void aggregateEventTypeForChunk(ChunkHeader ch, List<EventType> types, HashSet<Long> foundIds) throws IOException {
        MetadataDescriptor m = ch.readMetadata();
        for (EventType t : m.getEventTypes()) {
            if (foundIds.contains(t.getId())) continue;
            types.add(t);
            foundIds.add(t.getId());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.eof = true;
            this.input.close();
            this.chunkParser = null;
            this.input = null;
            this.nextEvent = null;
        }
    }

    public static List<RecordedEvent> readAllEvents(Path path) throws IOException {
        try (RecordingFile r = new RecordingFile(path);){
            ArrayList<RecordedEvent> list = new ArrayList<RecordedEvent>();
            while (r.hasMoreEvents()) {
                list.add(r.readEvent());
            }
            ArrayList<RecordedEvent> arrayList = list;
            return arrayList;
        }
    }

    private void findNext() throws IOException {
        while (this.nextEvent == null) {
            if (this.chunkParser == null) {
                this.chunkParser = new ChunkParser(this.input);
            } else if (!this.chunkParser.isLastChunk()) {
                this.chunkParser = this.chunkParser.nextChunkParser();
            } else {
                this.eof = true;
                return;
            }
            this.nextEvent = this.chunkParser.readEvent();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.input == null) {
            throw new IOException("Stream Closed");
        }
    }

    static {
        RecordingInternals.INSTANCE = new RecordingInternals(){

            @Override
            public List<Type> readTypes(RecordingFile file) throws IOException {
                return file.readTypes();
            }

            @Override
            public boolean isLastEventInChunk(RecordingFile file) {
                return file.isLastEventInChunk;
            }

            @Override
            public Object getOffsetDataTime(RecordedObject event, String name) {
                return event.getOffsetDateTime(name);
            }

            @Override
            public void sort(List<RecordedEvent> events) {
                Collections.sort(events, (e1, e2) -> Long.compare(e1.endTime, e2.endTime));
            }
        };
    }
}

