/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Unsigned;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class AnnotationConstruct {
    private List<AnnotationElement> annotationElements = Collections.emptyList();
    private byte unsignedFlag = (byte)-1;

    public AnnotationConstruct(List<AnnotationElement> ann) {
        this.annotationElements = ann;
    }

    public AnnotationConstruct() {
    }

    public void setAnnotationElements(List<AnnotationElement> elements) {
        this.annotationElements = Utils.smallUnmodifiable(elements);
    }

    public String getLabel() {
        Label label = (Label)this.getAnnotation(Label.class);
        if (label == null) {
            return null;
        }
        return label.value();
    }

    public String getDescription() {
        Description description = (Description)this.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    public final <T> T getAnnotation(Class<? extends Annotation> clazz) {
        AnnotationElement ae = this.getAnnotationElement(clazz);
        if (ae != null) {
            return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationInvokationHandler(ae));
        }
        return null;
    }

    public List<AnnotationElement> getUnmodifiableAnnotationElements() {
        return this.annotationElements;
    }

    boolean remove(AnnotationElement annotation) {
        return this.annotationElements.remove(annotation);
    }

    private AnnotationElement getAnnotationElement(Class<? extends Annotation> clazz) {
        long id = Type.getTypeId(clazz);
        String className = clazz.getName();
        for (AnnotationElement a : this.getUnmodifiableAnnotationElements()) {
            if (a.getTypeId() != id || !a.getTypeName().equals(className)) continue;
            return a;
        }
        for (AnnotationElement a : this.getUnmodifiableAnnotationElements()) {
            if (!a.getTypeName().equals(className)) continue;
            return a;
        }
        return null;
    }

    public boolean hasUnsigned() {
        if (this.unsignedFlag < 0) {
            Unsigned unsigned = (Unsigned)this.getAnnotation(Unsigned.class);
            this.unsignedFlag = (byte)(unsigned != null ? 1 : 0);
        }
        return this.unsignedFlag == 1;
    }

    private static final class AnnotationInvokationHandler
    implements InvocationHandler {
        private final AnnotationElement annotationElement;

        AnnotationInvokationHandler(AnnotationElement a) {
            this.annotationElement = a;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            int parameters = method.getTypeParameters().length;
            if (parameters == 0 && this.annotationElement.hasValue(methodName)) {
                return this.annotationElement.getValue(methodName);
            }
            throw new UnsupportedOperationException("Flight Recorder proxy only supports members declared in annotation interfaces, i.e. not toString, equals etc.");
        }
    }
}

