/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.SecuritySupport;

public final class JVMSupport {
    private static final String UNSUPPORTED_VM_MESSAGE = "Flight Recorder is not supported on this VM";
    private static final boolean notAvailable = !JVMSupport.checkAvailability();

    private static boolean checkAvailability() {
        try {
            if (SecuritySupport.getBooleanProperty("jfr.unsupported.vm")) {
                return false;
            }
        }
        catch (NoClassDefFoundError cnfe) {
            return false;
        }
        try {
            JVM.getJVM().isAvailable();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void ensureWithInternalError() {
        if (notAvailable) {
            throw new InternalError(UNSUPPORTED_VM_MESSAGE);
        }
    }

    public static void ensureWithIOException() throws IOException {
        if (notAvailable) {
            throw new IOException(UNSUPPORTED_VM_MESSAGE);
        }
    }

    public static void ensureWithIllegalStateException() {
        if (notAvailable) {
            throw new IllegalStateException(UNSUPPORTED_VM_MESSAGE);
        }
    }

    public static boolean isNotAvailable() {
        return notAvailable;
    }

    public static void tryToInitializeJVM() {
    }
}

