/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Modifier;
import jdk.jfr.Event;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.EventHandlerProxyCreator;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;
import jdk.jfr.internal.instrument.JDKEvents;

final class JVMUpcalls {
    JVMUpcalls() {
    }

    static byte[] onRetransform(long traceId, boolean dummy, Class<?> clazz, byte[] oldBytes) throws Throwable {
        try {
            if (Event.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                EventHandler handler = Utils.getHandler(clazz.asSubclass(Event.class));
                if (handler == null) {
                    Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "No event handler found for " + clazz.getName() + ". Ignoring instrumentation request.");
                    return oldBytes;
                }
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Adding instrumentation to event class " + clazz.getName() + " using retransform");
                EventInstrumentation ei = new EventInstrumentation(clazz.getSuperclass(), oldBytes, traceId);
                byte[] bytes = ei.buildInstrumented();
                ASMToolkit.logASM(clazz.getName(), bytes);
                return bytes;
            }
            return JDKEvents.retransformCallback(clazz, oldBytes);
        }
        catch (Throwable t) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Unexpected error when adding instrumentation to event class " + clazz.getName());
            return oldBytes;
        }
    }

    static byte[] bytesForEagerInstrumentation(long traceId, boolean forceInstrumentation, Class<?> superClass, byte[] oldBytes) throws Throwable {
        if (JVMSupport.isNotAvailable()) {
            return oldBytes;
        }
        String eventName = "<Unknown>";
        try {
            MetadataRepository mr;
            EventInstrumentation ei = new EventInstrumentation(superClass, oldBytes, traceId);
            eventName = ei.getEventName();
            if (!(forceInstrumentation || ((mr = MetadataRepository.getInstance()).isEnabled(ei.getEventName()) || ei.isEnabled()) && ei.isRegistered())) {
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Skipping instrumentation for event type " + eventName + " since event was disabled on class load");
                return oldBytes;
            }
            ei.setGuardHandler(true);
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Adding " + (forceInstrumentation ? "forced " : "") + "instrumentation for event type " + eventName + " during initial class load");
            EventHandlerCreator eh = new EventHandlerCreator(traceId, ei.getSettingInfos(), ei.getFieldInfos());
            eh.makeEventHandlerClass();
            byte[] bytes = ei.buildInstrumented();
            ASMToolkit.logASM(ei.getClassName() + "(" + traceId + ")", bytes);
            return bytes;
        }
        catch (Throwable t) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Unexpected error when adding instrumentation for event type " + eventName);
            return oldBytes;
        }
    }

    static Thread createRecorderThread(ThreadGroup systemThreadGroup, ClassLoader contextClassLoader) {
        return SecuritySupport.createRecorderThread(systemThreadGroup, contextClassLoader);
    }

    static Class<? extends EventHandler> getEventHandlerProxyClass() {
        return EventHandlerProxyCreator.proxyClass;
    }
}

