/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.SecuritySupport;

public final class Repository {
    private static final int MAX_REPO_CREATION_RETRIES = 1000;
    private static final JVM jvm = JVM.getJVM();
    private static final Repository instance = new Repository();
    public static final DateTimeFormatter REPO_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private final Set<SecuritySupport.SafePath> cleanupDirectories = new HashSet<SecuritySupport.SafePath>();
    private SecuritySupport.SafePath baseLocation;
    private SecuritySupport.SafePath repository;

    private Repository() {
    }

    public static Repository getRepository() {
        return instance;
    }

    public synchronized void setBasePath(SecuritySupport.SafePath baseLocation) throws Exception {
        this.repository = Repository.createRepository(baseLocation);
        try {
            SecuritySupport.delete(this.repository);
        }
        catch (IOException ioe) {
            Logger.log(LogTag.JFR, LogLevel.INFO, "Could not delete disk repository " + this.repository);
        }
        this.baseLocation = baseLocation;
    }

    synchronized void ensureRepository() throws Exception {
        if (this.baseLocation == null) {
            this.setBasePath(SecuritySupport.JAVA_IO_TMPDIR);
        }
    }

    synchronized RepositoryChunk newChunk(Instant timestamp) {
        try {
            if (!SecuritySupport.existDirectory(this.repository)) {
                this.repository = Repository.createRepository(this.baseLocation);
                jvm.setRepositoryLocation(this.repository.toString());
                this.cleanupDirectories.add(this.repository);
            }
            return new RepositoryChunk(this.repository, timestamp);
        }
        catch (Exception e) {
            String errorMsg = String.format("Could not create chunk in repository %s, %s", this.repository, e.getMessage());
            Logger.log(LogTag.JFR, LogLevel.ERROR, errorMsg);
            jvm.abort(errorMsg);
            throw new InternalError("Could not abort after JFR disk creation error");
        }
    }

    private static SecuritySupport.SafePath createRepository(SecuritySupport.SafePath basePath) throws Exception {
        int i;
        String basename;
        SecuritySupport.SafePath canonicalBaseRepositoryPath = Repository.createRealBasePath(basePath);
        SecuritySupport.SafePath f = null;
        String name = basename = REPO_DATE_FORMAT.format(LocalDateTime.now()) + "_" + JVM.getJVM().getPid();
        for (i = 0; i < 1000 && !Repository.tryToUseAsRepository(f = new SecuritySupport.SafePath(canonicalBaseRepositoryPath.toPath().resolve(name))); ++i) {
            name = basename + "_" + i;
        }
        if (i == 1000) {
            throw new Exception("Unable to create JFR repository directory using base location (" + basePath + ")");
        }
        SecuritySupport.SafePath canonicalRepositoryPath = SecuritySupport.toRealPath(f);
        return canonicalRepositoryPath;
    }

    private static SecuritySupport.SafePath createRealBasePath(SecuritySupport.SafePath safePath) throws Exception {
        if (SecuritySupport.exists(safePath)) {
            if (!SecuritySupport.isWritable(safePath)) {
                throw new IOException("JFR repository directory (" + safePath.toString() + ") exists, but isn't writable");
            }
            return SecuritySupport.toRealPath(safePath);
        }
        SecuritySupport.SafePath p = SecuritySupport.createDirectories(safePath);
        return SecuritySupport.toRealPath(p);
    }

    private static boolean tryToUseAsRepository(SecuritySupport.SafePath path) {
        Path parent = path.toPath().getParent();
        if (parent == null) {
            return false;
        }
        try {
            try {
                SecuritySupport.createDirectories(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!SecuritySupport.exists(path)) {
                return false;
            }
            return SecuritySupport.isDirectory(path);
        }
        catch (IOException io) {
            return false;
        }
    }

    synchronized void clear() {
        for (SecuritySupport.SafePath p : this.cleanupDirectories) {
            try {
                SecuritySupport.clearDirectory(p);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Removed repository " + p);
            }
            catch (IOException e) {
                Logger.log(LogTag.JFR, LogLevel.ERROR, "Repository " + p + " could not be removed at shutdown: " + e.getMessage());
            }
        }
    }

    public synchronized SecuritySupport.SafePath getRepositoryPath() {
        return this.repository;
    }
}

