/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.handlers.EventHandler;
import jdk.jfr.internal.settings.PeriodSetting;
import jdk.jfr.internal.settings.StackTraceSetting;
import jdk.jfr.internal.settings.ThresholdSetting;

public final class Utils {
    private static final String INFINITY = "infinity";
    private static Boolean SAVE_GENERATED;
    public static final String EVENTS_PACKAGE_NAME = "jdk.jfr.events";
    public static final String INSTRUMENT_PACKAGE_NAME = "jdk.jfr.internal.instrument";
    public static final String HANDLERS_PACKAGE_NAME = "jdk.jfr.internal.handlers";
    public static final String REGISTER_EVENT = "registerEvent";
    public static final String ACCESS_FLIGHT_RECORDER = "accessFlightRecorder";
    private static final String LEGACY_EVENT_NAME_PREFIX = "com.oracle.jdk.";

    public static void checkAccessFlightRecorder() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new FlightRecorderPermission(ACCESS_FLIGHT_RECORDER));
        }
    }

    public static void checkRegisterPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new FlightRecorderPermission(REGISTER_EVENT));
        }
    }

    private static String formatDataAmount(String formatter, long amount) {
        int exp = (int)(Math.log(Math.abs(amount)) / Math.log(1024.0));
        char unitPrefix = "kMGTPE".charAt(exp - 1);
        return String.format(formatter, (double)amount / Math.pow(1024.0, exp), Character.valueOf(unitPrefix));
    }

    public static String formatBytesCompact(long bytes) {
        if (bytes < 1024L) {
            return String.valueOf(bytes);
        }
        return Utils.formatDataAmount("%.1f%cB", bytes);
    }

    public static String formatBits(long bits) {
        if (bits == 1L || bits == -1L) {
            return bits + " bit";
        }
        if (bits < 1024L && bits > -1024L) {
            return bits + " bits";
        }
        return Utils.formatDataAmount("%.1f %cbit", bits);
    }

    public static String formatBytes(long bytes) {
        if (bytes == 1L || bytes == -1L) {
            return bytes + " byte";
        }
        if (bytes < 1024L && bytes > -1024L) {
            return bytes + " bytes";
        }
        return Utils.formatDataAmount("%.1f %cB", bytes);
    }

    public static String formatBytesPerSecond(long bytes) {
        if (bytes < 1024L && bytes > -1024L) {
            return bytes + " byte/s";
        }
        return Utils.formatDataAmount("%.1f %cB/s", bytes);
    }

    public static String formatBitsPerSecond(long bits) {
        if (bits < 1024L && bits > -1024L) {
            return bits + " bps";
        }
        return Utils.formatDataAmount("%.1f %cbps", bits);
    }

    public static String formatTimespan(Duration dValue, String separation) {
        if (dValue == null) {
            return "0";
        }
        long value = dValue.toNanos();
        TimespanUnit result = TimespanUnit.NANOSECONDS;
        TimespanUnit[] timespanUnitArray = TimespanUnit.values();
        int n = timespanUnitArray.length;
        for (int i = 0; i < n; ++i) {
            TimespanUnit unit;
            result = unit = timespanUnitArray[i];
            long amount = unit.amount;
            if (result == TimespanUnit.DAYS || value < amount || value % amount != 0L) break;
            value /= amount;
        }
        return String.format("%d%s%s", value, separation, result.text);
    }

    public static long parseTimespanWithInfinity(String s) {
        if (INFINITY.equals(s)) {
            return Long.MAX_VALUE;
        }
        return Utils.parseTimespan(s);
    }

    public static long parseTimespan(String s) {
        if (s.endsWith("ns")) {
            return Long.parseLong(s.substring(0, s.length() - 2).trim());
        }
        if (s.endsWith("us")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 2).trim()), TimeUnit.MICROSECONDS);
        }
        if (s.endsWith("ms")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 2).trim()), TimeUnit.MILLISECONDS);
        }
        if (s.endsWith("s")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("m")) {
            return 60L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("h")) {
            return 3600L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("d")) {
            return 86400L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("'" + s + "' is not a valid timespan. Shoule be numeric value followed by a unit, i.e. 20 ms. Valid units are ns, us, s, m, h and d.");
        }
        throw new NumberFormatException("Timespan + '" + s + "' is missing unit. Valid units are ns, us, s, m, h and d.");
    }

    static List<Annotation> getAnnotations(Class<?> clazz) {
        ArrayList<Annotation> annos = new ArrayList<Annotation>();
        for (Annotation a : clazz.getAnnotations()) {
            annos.addAll(Utils.getAnnotation(a));
        }
        return annos;
    }

    private static List<? extends Annotation> getAnnotation(Annotation a) {
        Class<? extends Annotation> repeatClass;
        Class<?> candidate;
        Repeatable r;
        Class<?> returnType;
        Class<? extends Annotation> annotated = a.annotationType();
        Method valueMethod = Utils.getValueMethod(annotated);
        if (valueMethod != null && (returnType = valueMethod.getReturnType()).isArray() && (r = (candidate = returnType.getComponentType()).getAnnotation(Repeatable.class)) != null && annotated == (repeatClass = r.value())) {
            return Utils.getAnnotationValues(a, valueMethod);
        }
        ArrayList<Annotation> annos = new ArrayList<Annotation>();
        annos.add(a);
        return annos;
    }

    static boolean isAfter(RecordingState stateToTest, RecordingState b) {
        return stateToTest.ordinal() > b.ordinal();
    }

    static boolean isBefore(RecordingState stateToTest, RecordingState b) {
        return stateToTest.ordinal() < b.ordinal();
    }

    static boolean isState(RecordingState stateToTest, RecordingState ... states) {
        for (RecordingState s : states) {
            if (s != stateToTest) continue;
            return true;
        }
        return false;
    }

    private static List<Annotation> getAnnotationValues(Annotation a, Method valueMethod) {
        try {
            return Arrays.asList((Annotation[])valueMethod.invoke((Object)a, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return new ArrayList<Annotation>();
        }
    }

    private static Method getValueMethod(Class<?> annotated) {
        try {
            return annotated.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void touch(Path dumpFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(dumpFile.toFile(), "rw");
        raf.close();
    }

    public static Class<?> unboxType(Class<?> t) {
        if (t == Integer.class) {
            return Integer.TYPE;
        }
        if (t == Long.class) {
            return Long.TYPE;
        }
        if (t == Float.class) {
            return Float.TYPE;
        }
        if (t == Double.class) {
            return Double.TYPE;
        }
        if (t == Byte.class) {
            return Byte.TYPE;
        }
        if (t == Short.class) {
            return Short.TYPE;
        }
        if (t == Boolean.class) {
            return Boolean.TYPE;
        }
        if (t == Character.class) {
            return Character.TYPE;
        }
        return t;
    }

    static long nanosToTicks(long nanos) {
        return (long)((double)nanos * JVM.getJVM().getTimeConversionFactor());
    }

    static synchronized EventHandler getHandler(Class<? extends Event> eventClass) {
        Utils.ensureValidEventSubclass(eventClass);
        try {
            Field f = eventClass.getDeclaredField("eventHandler");
            SecuritySupport.setAccessible(f);
            return (EventHandler)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new InternalError("Could not access event handler");
        }
    }

    static synchronized void setHandler(Class<? extends Event> eventClass, EventHandler handler) {
        Utils.ensureValidEventSubclass(eventClass);
        try {
            Field field = eventClass.getDeclaredField("eventHandler");
            SecuritySupport.setAccessible(field);
            field.set(null, handler);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new InternalError("Could not access event handler");
        }
    }

    public static Map<String, String> sanitizeNullFreeStringMap(Map<String, String> settings) {
        HashMap<String, String> map = new HashMap<String, String>(settings.size());
        for (Map.Entry<String, String> e : settings.entrySet()) {
            String key = e.getKey();
            if (key == null) {
                throw new NullPointerException("Null key is not allowed in map");
            }
            String value = e.getValue();
            if (value == null) {
                throw new NullPointerException("Null value is not allowed in map");
            }
            map.put(key, value);
        }
        return map;
    }

    public static <T> List<T> sanitizeNullFreeList(List<T> elements, Class<T> clazz) {
        ArrayList<T> sanitized = new ArrayList<T>(elements.size());
        for (T element : elements) {
            if (element == null) {
                throw new NullPointerException("Null is not an allowed element in list");
            }
            if (element.getClass() != clazz) {
                throw new ClassCastException();
            }
            sanitized.add(element);
        }
        return sanitized;
    }

    static List<Field> getVisibleEventFields(Class<?> clazz) {
        Utils.ensureValidEventSubclass(clazz);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = clazz; c != Event.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (c != clazz && Modifier.isPrivate(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static void ensureValidEventSubclass(Class<?> eventClass) {
        if (Event.class.isAssignableFrom(eventClass) && Modifier.isAbstract(eventClass.getModifiers())) {
            throw new IllegalArgumentException("Abstract event classes are not allowed");
        }
        if (eventClass == Event.class || !Event.class.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("Must be a subclass to " + Event.class.getName());
        }
    }

    public static void writeGeneratedASM(String className, byte[] bytes) {
        if (SAVE_GENERATED == null) {
            SAVE_GENERATED = SecuritySupport.getBooleanProperty("jfr.save.generated.asm");
        }
        if (SAVE_GENERATED.booleanValue()) {
            try {
                try (FileOutputStream fos = new FileOutputStream(className + ".class");){
                    fos.write(bytes);
                }
                var3_4 = null;
                try (FileWriter fw = new FileWriter(className + ".asm");
                     PrintWriter pw = new PrintWriter(fw);){
                    ClassReader cr = new ClassReader(bytes);
                    CheckClassAdapter.verify(cr, true, pw);
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.INFO, "Instrumented code saved to " + className + ".class and .asm");
            }
            catch (IOException e) {
                Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.INFO, "Could not save instrumented code, for " + className + ".class and .asm");
            }
        }
    }

    public static void ensureInitialized(Class<? extends Event> eventClass) {
        SecuritySupport.ensureClassIsInitialized(eventClass);
    }

    public static Object makePrimitiveArray(String typeName, List<Object> values) {
        int length = values.size();
        switch (typeName) {
            case "int": {
                int[] ints = new int[length];
                for (int i = 0; i < length; ++i) {
                    ints[i] = (Integer)values.get(i);
                }
                return ints;
            }
            case "long": {
                long[] longs = new long[length];
                for (int i = 0; i < length; ++i) {
                    longs[i] = (Long)values.get(i);
                }
                return longs;
            }
            case "float": {
                float[] floats = new float[length];
                for (int i = 0; i < length; ++i) {
                    floats[i] = ((Float)values.get(i)).floatValue();
                }
                return floats;
            }
            case "double": {
                double[] doubles = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubles[i] = (Double)values.get(i);
                }
                return doubles;
            }
            case "short": {
                short[] shorts = new short[length];
                for (int i = 0; i < length; ++i) {
                    shorts[i] = (Short)values.get(i);
                }
                return shorts;
            }
            case "char": {
                char[] chars = new char[length];
                for (int i = 0; i < length; ++i) {
                    chars[i] = ((Character)values.get(i)).charValue();
                }
                return chars;
            }
            case "byte": {
                byte[] bytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    bytes[i] = (Byte)values.get(i);
                }
                return bytes;
            }
            case "boolean": {
                boolean[] booleans = new boolean[length];
                for (int i = 0; i < length; ++i) {
                    booleans[i] = (Boolean)values.get(i);
                }
                return booleans;
            }
            case "java.lang.String": {
                String[] strings = new String[length];
                for (int i = 0; i < length; ++i) {
                    strings[i] = (String)values.get(i);
                }
                return strings;
            }
        }
        return null;
    }

    public static boolean isSettingVisible(Control c, boolean hasEventHook) {
        if (c instanceof ThresholdSetting) {
            return !hasEventHook;
        }
        if (c instanceof PeriodSetting) {
            return hasEventHook;
        }
        if (c instanceof StackTraceSetting) {
            return !hasEventHook;
        }
        return true;
    }

    public static boolean isSettingVisible(long typeId, boolean hasEventHook) {
        if (ThresholdSetting.isType(typeId)) {
            return !hasEventHook;
        }
        if (PeriodSetting.isType(typeId)) {
            return hasEventHook;
        }
        if (StackTraceSetting.isType(typeId)) {
            return !hasEventHook;
        }
        return true;
    }

    public static Type getValidType(Class<?> type, String name) {
        Objects.requireNonNull(type, "Null is not a valid type for value descriptor " + name);
        if (type.isArray() && (type = type.getComponentType()) != String.class && !type.isPrimitive()) {
            throw new IllegalArgumentException("Only arrays of primitives and Strings are allowed");
        }
        Type knownType = Type.getKnownType(type);
        if (knownType == null || knownType == Type.STACK_TRACE) {
            throw new IllegalArgumentException("Only primitive types, java.lang.Thread, java.lang.String and java.lang.Class are allowed for value descriptors. " + type.getName());
        }
        return knownType;
    }

    public static <T> List<T> smallUnmodifiable(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.unmodifiableList(list);
    }

    public static String upgradeLegacyJDKEvent(String eventName) {
        int index;
        if (eventName.length() <= LEGACY_EVENT_NAME_PREFIX.length()) {
            return eventName;
        }
        if (eventName.startsWith(LEGACY_EVENT_NAME_PREFIX) && (index = eventName.lastIndexOf(".")) == LEGACY_EVENT_NAME_PREFIX.length() - 1) {
            return "jdk." + eventName.substring(index + 1);
        }
        return eventName;
    }

    public static String makeFilename(Recording recording) {
        String pid = JVM.getJVM().getPid();
        String date = Repository.REPO_DATE_FORMAT.format(LocalDateTime.now());
        String idText = recording == null ? "" : "-id-" + Long.toString(recording.getId());
        return "hotspot-pid-" + pid + idText + "-" + date + ".jfr";
    }

    private static enum TimespanUnit {
        NANOSECONDS("ns", 1000L),
        MICROSECONDS("us", 1000L),
        MILLISECONDS("ms", 1000L),
        SECONDS("s", 60L),
        MINUTES("m", 60L),
        HOURS("h", 24L),
        DAYS("d", 7L);

        final String text;
        final long amount;

        private TimespanUnit(String unit, long amount) {
            this.text = unit;
            this.amount = amount;
        }
    }
}

