/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import jdk.jfr.EventType;
import jdk.jfr.Recording;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdCheck
extends AbstractDCmd {
    DCmdCheck() {
    }

    public String execute(String recordingText, Boolean verbose) throws DCmdException {
        this.executeInternal(recordingText, verbose);
        return this.getResult();
    }

    private void executeInternal(String name, Boolean verbose) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdCheck: name=" + name + ", verbose=" + verbose);
        }
        if (verbose == null) {
            verbose = Boolean.FALSE;
        }
        if (name != null) {
            this.printRecording(this.findRecording(name), verbose);
            return;
        }
        List<Recording> recordings = this.getRecordings();
        if (!verbose.booleanValue() && recordings.isEmpty()) {
            this.println("No available recordings.", new Object[0]);
            this.println();
            this.println("Use jcmd " + this.getPid() + " JFR.start to start a recording.", new Object[0]);
            return;
        }
        boolean first = true;
        for (Recording recording : recordings) {
            if (!first) {
                this.println();
                if (Boolean.TRUE.equals(verbose)) {
                    this.println();
                }
            }
            first = false;
            this.printRecording(recording, verbose);
        }
    }

    private void printRecording(Recording recording, boolean verbose) {
        this.printGeneral(recording);
        if (verbose) {
            this.println();
            this.printSetttings(recording);
        }
    }

    private void printGeneral(Recording recording) {
        Duration maxAge;
        long maxSize;
        this.print("Recording " + recording.getId() + ": name=" + recording.getName());
        Duration duration = recording.getDuration();
        if (duration != null) {
            this.print(" duration=");
            this.printTimespan(duration, "");
        }
        if ((maxSize = recording.getMaxSize()) != 0L) {
            this.print(" maxsize=");
            this.print(Utils.formatBytesCompact(maxSize));
        }
        if ((maxAge = recording.getMaxAge()) != null) {
            this.print(" maxage=");
            this.printTimespan(maxAge, "");
        }
        this.print(" (" + recording.getState().toString().toLowerCase() + ")");
        this.println();
    }

    private void printSetttings(Recording recording) {
        Map<String, String> settings = recording.getSettings();
        for (EventType eventType : DCmdCheck.sortByEventPath(this.getFlightRecorder().getEventTypes())) {
            StringJoiner sj = new StringJoiner(",", "[", "]");
            sj.setEmptyValue("");
            for (SettingDescriptor s : eventType.getSettingDescriptors()) {
                String settingsPath = eventType.getName() + "#" + s.getName();
                if (!settings.containsKey(settingsPath)) continue;
                sj.add(s.getName() + "=" + settings.get(settingsPath));
            }
            String settingsText = sj.toString();
            if (settingsText.isEmpty()) continue;
            this.print(" %s (%s)", eventType.getLabel(), eventType.getName());
            this.println();
            this.println("   " + settingsText, new Object[0]);
        }
    }

    private static List<EventType> sortByEventPath(Collection<EventType> events) {
        ArrayList<EventType> sorted = new ArrayList<EventType>();
        sorted.addAll(events);
        Collections.sort(sorted, new Comparator<EventType>(){

            @Override
            public int compare(EventType e1, EventType e2) {
                return e1.getName().compareTo(e2.getName());
            }
        });
        return sorted;
    }
}

