/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdDump
extends AbstractDCmd {
    DCmdDump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String name, String filename, Long maxAge, Long maxSize, String begin, String end, Boolean pathToGcRoots) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdDump: name=" + name + ", filename=" + filename + ", maxage=" + maxAge + ", maxsize=" + maxSize + ", begin=" + begin + ", end" + end + ", path-to-gc-roots=" + pathToGcRoots);
        }
        if (FlightRecorder.getFlightRecorder().getRecordings().isEmpty()) {
            throw new DCmdException("No recordings to dump from. Use JFR.start to start a recording.", new Object[0]);
        }
        if (maxAge != null) {
            if (end != null || begin != null) {
                throw new DCmdException("Dump failed, maxage can't be combined with begin or end.", new Object[0]);
            }
            if (maxAge < 0L) {
                throw new DCmdException("Dump failed, maxage can't be negative.", new Object[0]);
            }
            if (maxAge == 0L) {
                maxAge = 0x3FFFFFFFFFFFFFFFL;
            }
        }
        if (maxSize != null) {
            if (maxSize < 0L) {
                throw new DCmdException("Dump failed, maxsize can't be negative.", new Object[0]);
            }
            if (maxSize == 0L) {
                maxSize = 0x3FFFFFFFFFFFFFFFL;
            }
        }
        Instant beginTime = this.parseTime(begin, "begin");
        Instant endTime = this.parseTime(end, "end");
        if (beginTime != null && endTime != null && endTime.isBefore(beginTime)) {
            throw new DCmdException("Dump failed, begin must preceed end.", new Object[0]);
        }
        Duration duration = null;
        if (maxAge != null) {
            duration = Duration.ofNanos(maxAge);
            beginTime = Instant.now().minus(duration);
        }
        Recording recording = null;
        if (name != null) {
            recording = this.findRecording(name);
        }
        PlatformRecorder recorder = PrivateAccess.getInstance().getPlatformRecorder();
        try {
            PlatformRecorder platformRecorder = recorder;
            synchronized (platformRecorder) {
                this.dump(recorder, recording, name, filename, maxSize, pathToGcRoots, beginTime, endTime);
            }
        }
        catch (IOException | InvalidPathException e) {
            throw new DCmdException("Dump failed. Could not copy recording data. %s", e.getMessage());
        }
        return this.getResult();
    }

    public void dump(PlatformRecorder recorder, Recording recording, String name, String filename, Long maxSize, Boolean pathToGcRoots, Instant beginTime, Instant endTime) throws DCmdException, IOException {
        try (PlatformRecording r = this.newSnapShot(recorder, recording, pathToGcRoots);){
            r.filter(beginTime, endTime, maxSize);
            if (r.getChunks().isEmpty()) {
                throw new DCmdException("Dump failed. No data found in the specified interval.", new Object[0]);
            }
            WriteableUserPath wup = null;
            if (recording != null) {
                PlatformRecording pRecording = PrivateAccess.getInstance().getPlatformRecording(recording);
                wup = pRecording.getDestination();
            }
            if (filename != null || filename == null && wup == null) {
                SecuritySupport.SafePath safe = this.resolvePath(recording, filename);
                wup = new WriteableUserPath(safe.toPath());
            }
            r.dumpStopped(wup);
            this.reportOperationComplete("Dumped", name, new SecuritySupport.SafePath(wup.getRealPathText()));
        }
    }

    private Instant parseTime(String time, String parameter) throws DCmdException {
        if (time == null) {
            return null;
        }
        try {
            return Instant.parse(time);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDateTime ldt = LocalDateTime.parse(time);
                return ZonedDateTime.of(ldt, ZoneId.systemDefault()).toInstant();
            }
            catch (DateTimeParseException ldt) {
                try {
                    LocalTime lt = LocalTime.parse(time);
                    LocalDate ld = LocalDate.now();
                    Instant instant = ZonedDateTime.of(ld, lt, ZoneId.systemDefault()).toInstant();
                    Instant now = Instant.now();
                    if (instant.isAfter(now) && !instant.isBefore(now.plusSeconds(3600L))) {
                        ld = ld.minusDays(1L);
                    }
                    return ZonedDateTime.of(ld, lt, ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeParseException lt) {
                    if (time.startsWith("-")) {
                        try {
                            long durationNanos = Utils.parseTimespan(time.substring(1));
                            Duration duration = Duration.ofNanos(durationNanos);
                            return Instant.now().minus(duration);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    throw new DCmdException("Dump failed, not a valid %s time.", parameter);
                }
            }
        }
    }

    private PlatformRecording newSnapShot(PlatformRecorder recorder, Recording recording, Boolean pathToGcRoots) throws DCmdException, IOException {
        if (recording == null) {
            PlatformRecording snapshot = recorder.newTemporaryRecording();
            recorder.fillWithRecordedData(snapshot, pathToGcRoots);
            return snapshot;
        }
        PlatformRecording pr = PrivateAccess.getInstance().getPlatformRecording(recording);
        return pr.newSnapshotClone("Dumped by user", pathToGcRoots);
    }
}

