/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.instrument.JIInliner;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIMethodMergeAdapter;
import jdk.jfr.internal.instrument.JITypeMapping;

@Deprecated
final class JIClassInstrumentation {
    private final Class<?> instrumentor;
    private final String targetName;
    private final String instrumentorName;
    private final byte[] newBytes;
    private final ClassReader targetClassReader;
    private final ClassReader instrClassReader;

    JIClassInstrumentation(Class<?> instrumentor, Class<?> target, byte[] old_target_bytes) throws ClassNotFoundException, IOException {
        this.instrumentorName = instrumentor.getName();
        this.targetName = target.getName();
        this.instrumentor = instrumentor;
        this.targetClassReader = new ClassReader(old_target_bytes);
        this.instrClassReader = new ClassReader(JIClassInstrumentation.getOriginalClassBytes(instrumentor));
        this.newBytes = this.makeBytecode();
        Utils.writeGeneratedASM(target.getName(), this.newBytes);
    }

    private static byte[] getOriginalClassBytes(Class<?> clazz) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String name = "/" + clazz.getName().replace(".", "/") + ".class";
        InputStream is = SecuritySupport.getResourceAsStream(name);
        byte[] buffer = new byte[16384];
        while ((bytesRead = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        baos.flush();
        is.close();
        return baos.toByteArray();
    }

    private byte[] makeBytecode() throws IOException, ClassNotFoundException {
        ArrayList<Method> instrumentationMethods = new ArrayList<Method>();
        for (Method m : this.instrumentor.getDeclaredMethods()) {
            JIInstrumentationMethod im = m.getAnnotation(JIInstrumentationMethod.class);
            if (im == null) continue;
            instrumentationMethods.add(m);
        }
        ClassNode temporary = new ClassNode();
        JIInliner inliner = new JIInliner(327680, temporary, this.targetName, this.instrumentorName, this.targetClassReader, instrumentationMethods);
        this.instrClassReader.accept(inliner, 8);
        ClassWriter cw = new ClassWriter(2);
        JIMethodMergeAdapter ma = new JIMethodMergeAdapter(cw, temporary, instrumentationMethods, (JITypeMapping[])this.instrumentor.getAnnotationsByType(JITypeMapping.class));
        this.targetClassReader.accept(ma, 8);
        return cw.toByteArray();
    }

    public byte[] getNewBytes() {
        return (byte[])this.newBytes.clone();
    }
}

