/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="java.io.RandomAccessFile")
final class RandomAccessFileInstrumentor {
    private String path;

    private RandomAccessFileInstrumentor() {
    }

    @JIInstrumentationMethod
    public int read() throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read();
        }
        int result = 0;
        try {
            event.begin();
            result = this.read();
            if (result < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = 1L;
            }
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] b) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(b);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(b);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] b, int off, int len) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(b, off, len);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(b, off, len);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    @JIInstrumentationMethod
    public void write(int b) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b);
            return;
        }
        try {
            event.begin();
            this.write(b);
            event.bytesWritten = 1L;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }

    @JIInstrumentationMethod
    public void write(byte[] b) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b);
            return;
        }
        try {
            event.begin();
            this.write(b);
            event.bytesWritten = b.length;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] b, int off, int len) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b, off, len);
            return;
        }
        try {
            event.begin();
            this.write(b, off, len);
            event.bytesWritten = len;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }
}

