/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.jfc;

import java.util.LinkedHashMap;
import java.util.Map;
import jdk.internal.org.xml.sax.Attributes;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;

final class JFCParserHandler
extends DefaultHandler {
    private static final String ELEMENT_CONFIGURATION = "configuration";
    private static final String ELEMENT_EVENT_TYPE = "event";
    private static final String ELEMENT_SETTING = "setting";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_LABEL = "label";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_PROVIDER = "provider";
    private static final String ATTRIBUTE_VERSION = "version";
    final Map<String, String> settings = new LinkedHashMap<String, String>();
    private String currentEventPath;
    private String currentSettingsName;
    private StringBuilder currentCharacters;
    String label;
    String provider;
    String description;

    JFCParserHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (qName.toLowerCase()) {
            case "configuration": {
                String version = attributes.getValue(ATTRIBUTE_VERSION);
                if (version == null || !version.startsWith("2.")) {
                    throw new SAXException("This version of Flight Recorder can only read JFC file format version 2.x");
                }
                this.label = attributes.getValue(ATTRIBUTE_LABEL);
                this.description = this.getOptional(attributes, ATTRIBUTE_DESCRIPTION, "");
                this.provider = this.getOptional(attributes, ATTRIBUTE_PROVIDER, "");
                break;
            }
            case "event": {
                this.currentEventPath = attributes.getValue(ATTRIBUTE_NAME);
                break;
            }
            case "setting": {
                this.currentSettingsName = attributes.getValue(ATTRIBUTE_NAME);
            }
        }
        this.currentCharacters = null;
    }

    private String getOptional(Attributes attributes, String name, String defaultValue) {
        String value = attributes.getValue(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentCharacters == null) {
            this.currentCharacters = new StringBuilder(length);
        }
        this.currentCharacters.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName.toLowerCase()) {
            case "configuration": {
                break;
            }
            case "event": {
                this.currentEventPath = null;
                break;
            }
            case "setting": {
                String settingsValue = this.currentCharacters == null ? "" : this.currentCharacters.toString();
                this.settings.put(this.currentEventPath + "#" + this.currentSettingsName, "" + settingsValue);
                this.currentSettingsName = null;
            }
        }
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }
}

