/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Period")
@Description(value="Record event at interval")
@Name(value="jdk.settings.Period")
public final class PeriodSetting
extends Control {
    private static final long typeId = Type.getTypeId(PeriodSetting.class);
    public static final String EVERY_CHUNK = "everyChunk";
    public static final String BEGIN_CHUNK = "beginChunk";
    public static final String END_CHUNK = "endChunk";
    public static final String NAME = "period";
    private final PlatformEventType eventType;
    private String value = "everyChunk";

    public PeriodSetting(PlatformEventType eventType, String defaultValue) {
        super(defaultValue);
        this.eventType = Objects.requireNonNull(eventType);
    }

    @Override
    public String combine(Set<String> values) {
        boolean beginChunk = false;
        boolean endChunk = false;
        Long min = null;
        String text = null;
        Iterator<String> iterator = values.iterator();
        block10: while (iterator.hasNext()) {
            String value;
            switch (value = iterator.next()) {
                case "everyChunk": {
                    beginChunk = true;
                    endChunk = true;
                    continue block10;
                }
                case "beginChunk": {
                    beginChunk = true;
                    continue block10;
                }
                case "endChunk": {
                    endChunk = true;
                    continue block10;
                }
            }
            long l = Utils.parseTimespanWithInfinity(value);
            if (min == null) {
                text = value;
                min = l;
                continue;
            }
            if (l >= min) continue;
            text = value;
            min = l;
        }
        if (min != null) {
            return text;
        }
        if (beginChunk && !endChunk) {
            return BEGIN_CHUNK;
        }
        if (!beginChunk && endChunk) {
            return END_CHUNK;
        }
        return EVERY_CHUNK;
    }

    @Override
    public void setValue(String value) {
        switch (value) {
            case "everyChunk": {
                this.eventType.setPeriod(0L, true, true);
                break;
            }
            case "beginChunk": {
                this.eventType.setPeriod(0L, true, false);
                break;
            }
            case "endChunk": {
                this.eventType.setPeriod(0L, false, true);
                break;
            }
            default: {
                long nanos = Utils.parseTimespanWithInfinity(value);
                if (nanos != Long.MAX_VALUE) {
                    this.eventType.setPeriod(nanos / 1000000L, false, false);
                    break;
                }
                this.eventType.setPeriod(Long.MAX_VALUE, false, false);
            }
        }
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long typeId) {
        return PeriodSetting.typeId == typeId;
    }
}

