/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.httpserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.Exported;

@Exported
public class Headers
implements Map<String, List<String>> {
    HashMap<String, List<String>> map = new HashMap(32);

    private String normalize(String key) {
        if (key == null) {
            return null;
        }
        int len = key.length();
        if (len == 0) {
            return key;
        }
        char[] b = key.toCharArray();
        if (b[0] >= 'a' && b[0] <= 'z') {
            b[0] = (char)(b[0] - 32);
        } else if (b[0] == '\r' || b[0] == '\n') {
            throw new IllegalArgumentException("illegal character in key");
        }
        for (int i = 1; i < len; ++i) {
            if (b[i] >= 'A' && b[i] <= 'Z') {
                b[i] = (char)(b[i] + 32);
                continue;
            }
            if (b[i] != '\r' && b[i] != '\n') continue;
            throw new IllegalArgumentException("illegal character in key");
        }
        return new String(b);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        return this.map.containsKey(this.normalize((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.map.get(this.normalize((String)key));
    }

    public String getFirst(String key) {
        List<String> l = this.map.get(this.normalize(key));
        if (l == null) {
            return null;
        }
        return l.get(0);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        for (String v : value) {
            Headers.checkValue(v);
        }
        return this.map.put(this.normalize(key), value);
    }

    public void add(String key, String value) {
        Headers.checkValue(value);
        String k = this.normalize(key);
        List<String> l = this.map.get(k);
        if (l == null) {
            l = new LinkedList<String>();
            this.map.put(k, l);
        }
        l.add(value);
    }

    private static void checkValue(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\r') {
                if (i >= len - 2) {
                    throw new IllegalArgumentException("Illegal CR found in header");
                }
                char c1 = value.charAt(i + 1);
                char c2 = value.charAt(i + 2);
                if (c1 != '\n') {
                    throw new IllegalArgumentException("Illegal char found after CR in header");
                }
                if (c2 != ' ' && c2 != '\t') {
                    throw new IllegalArgumentException("No whitespace found after CRLF in header");
                }
                i += 2;
                continue;
            }
            if (c != '\n') continue;
            throw new IllegalArgumentException("Illegal LF found in header");
        }
    }

    public void set(String key, String value) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(value);
        this.put(key, (List<String>)l);
    }

    @Override
    public List<String> remove(Object key) {
        return this.map.remove(this.normalize((String)key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> t) {
        this.map.putAll(t);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

