/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache javaHomePrefixCache = new ExpiringCache();

    public UnixFileSystem() {
        this.slash = AccessController.doPrivileged(new GetPropertyAction("file.separator")).charAt(0);
        this.colon = AccessController.doPrivileged(new GetPropertyAction("path.separator")).charAt(0);
        this.javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.colon;
    }

    private String normalize(String pathname, int len, int off) {
        int n;
        if (len == 0) {
            return pathname;
        }
        for (n = len; n > 0 && pathname.charAt(n - 1) == '/'; --n) {
        }
        if (n == 0) {
            return "/";
        }
        StringBuffer sb = new StringBuffer(pathname.length());
        if (off > 0) {
            sb.append(pathname.substring(0, off));
        }
        int prevChar = 0;
        for (int i = off; i < n; ++i) {
            char c = pathname.charAt(i);
            if (prevChar == 47 && c == '/') continue;
            sb.append(c);
            prevChar = c;
        }
        return sb.toString();
    }

    @Override
    public String normalize(String pathname) {
        int n = pathname.length();
        int prevChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = pathname.charAt(i);
            if (prevChar == 47 && c == '/') {
                return this.normalize(pathname, n, i - 1);
            }
            prevChar = c;
        }
        if (prevChar == 47) {
            return this.normalize(pathname, n, n - 1);
        }
        return pathname;
    }

    @Override
    public int prefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public String resolve(String parent, String child) {
        if (child.equals("")) {
            return parent;
        }
        if (child.charAt(0) == '/') {
            if (parent.equals("/")) {
                return child;
            }
            return parent + child;
        }
        if (parent.equals("/")) {
            return parent + child;
        }
        return parent + '/' + child;
    }

    @Override
    public String getDefaultParent() {
        return "/";
    }

    @Override
    public String fromURIPath(String path) {
        String p = path;
        if (p.endsWith("/") && p.length() > 1) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    @Override
    public boolean isAbsolute(File f) {
        return f.getPrefixLength() != 0;
    }

    @Override
    public boolean isInvalid(File f) {
        return f.getPath().indexOf(0) >= 0;
    }

    @Override
    public String resolve(File f) {
        if (this.isAbsolute(f)) {
            return f.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), f.getPath());
    }

    @Override
    public String canonicalize(String path) throws IOException {
        if (!useCanonCaches) {
            return this.canonicalize0(path);
        }
        String res = this.cache.get(path);
        if (res == null) {
            String dir = null;
            String resDir = null;
            if (useCanonPrefixCache && (dir = UnixFileSystem.parentOrNull(path)) != null && (resDir = this.javaHomePrefixCache.get(dir)) != null) {
                String filename = path.substring(1 + dir.length());
                res = resDir + this.slash + filename;
                this.cache.put(dir + this.slash + filename, res);
            }
            if (res == null) {
                File f;
                res = this.canonicalize0(path);
                this.cache.put(path, res);
                if (useCanonPrefixCache && dir != null && dir.startsWith(this.javaHome) && (resDir = UnixFileSystem.parentOrNull(res)) != null && resDir.equals(dir) && (f = new File(res)).exists() && !f.isDirectory()) {
                    this.javaHomePrefixCache.put(dir, resDir);
                }
            }
        }
        return res;
    }

    private native String canonicalize0(String var1) throws IOException;

    static String parentOrNull(String path) {
        int last;
        if (path == null) {
            return null;
        }
        char sep = File.separatorChar;
        int adjacentDots = 0;
        int nonDotCount = 0;
        for (int idx = last = path.length() - 1; idx > 0; --idx) {
            char c = path.charAt(idx);
            if (c == '.') {
                if (++adjacentDots < 2) continue;
                return null;
            }
            if (c == sep) {
                if (adjacentDots == 1 && nonDotCount == 0) {
                    return null;
                }
                if (idx == 0 || idx >= last - 1 || path.charAt(idx - 1) == sep) {
                    return null;
                }
                return path.substring(0, idx);
            }
            ++nonDotCount;
            adjacentDots = 0;
        }
        return null;
    }

    public native int getBooleanAttributes0(File var1);

    @Override
    public int getBooleanAttributes(File f) {
        int rv = this.getBooleanAttributes0(f);
        String name = f.getName();
        boolean hidden = name.length() > 0 && name.charAt(0) == '.';
        return rv | (hidden ? 8 : 0);
    }

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public boolean delete(File f) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.delete0(f);
    }

    private native boolean delete0(File var1);

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public boolean rename(File f1, File f2) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.rename0(f1, f2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    @Override
    public File[] listRoots() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException x) {
            return new File[0];
        }
    }

    @Override
    public native long getSpace(File var1, int var2);

    @Override
    public int compare(File f1, File f2) {
        return f1.getPath().compareTo(f2.getPath());
    }

    @Override
    public int hashCode(File f) {
        return f.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        UnixFileSystem.initIDs();
    }
}

