/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.internal.misc.TerminatingThreadLocal;
import sun.misc.Contended;
import sun.misc.VM;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    private volatile String name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long nativeParkEventPointer;
    private long tid;
    private static long threadSeqNumber;
    private volatile int threadStatus = 0;
    volatile Object parkBlocker;
    private volatile Interruptible blocker;
    private final Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    @Contended(value="tlr")
    long threadLocalRandomSeed;
    @Contended(value="tlr")
    int threadLocalRandomProbe;
    @Contended(value="tlr")
    int threadLocalRandomSecondarySeed;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible b) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = b;
        }
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos >= 500000 || nanos != 0 && millis == 0L) {
            ++millis;
        }
        Thread.sleep(millis);
    }

    private void init(ThreadGroup g, Runnable target, String name, long stackSize) {
        this.init(g, target, name, stackSize, null, true);
    }

    private void init(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        Thread parent = Thread.currentThread();
        SecurityManager security = System.getSecurityManager();
        if (g == null) {
            if (security != null) {
                g = security.getThreadGroup();
            }
            if (g == null) {
                g = parent.getThreadGroup();
            }
        }
        g.checkAccess();
        if (security != null && Thread.isCCLOverridden(this.getClass())) {
            security.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        g.addUnstarted();
        this.group = g;
        this.daemon = parent.isDaemon();
        this.priority = parent.getPriority();
        this.contextClassLoader = security == null || Thread.isCCLOverridden(parent.getClass()) ? parent.getContextClassLoader() : parent.contextClassLoader;
        this.inheritedAccessControlContext = acc != null ? acc : AccessController.getContext();
        this.target = target;
        this.setPriority(this.priority);
        if (inheritThreadLocals && parent.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parent.inheritableThreadLocals);
        }
        this.stackSize = stackSize;
        this.tid = Thread.nextThreadID();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable target) {
        this.init(null, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    Thread(Runnable target, AccessControlContext acc) {
        this.init(null, target, "Thread-" + Thread.nextThreadNum(), 0L, acc, false);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this.init(group, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String name) {
        this.init(null, null, name, 0L);
    }

    public Thread(ThreadGroup group, String name) {
        this.init(group, null, name, 0L);
    }

    public Thread(Runnable target, String name) {
        this.init(null, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this.init(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this.init(group, target, name, stackSize);
    }

    public synchronized void start() {
        if (this.threadStatus != 0) {
            throw new IllegalThreadStateException();
        }
        this.group.add(this);
        boolean started = false;
        try {
            this.start0();
            started = true;
        }
        finally {
            try {
                if (!started) {
                    this.group.threadStartFailed(this);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.threadLocals != null && TerminatingThreadLocal.REGISTRY.isPresent()) {
            TerminatingThreadLocal.threadTerminated();
        }
        if (this.group != null) {
            this.group.threadTerminated(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    @Deprecated
    public final void stop() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            this.checkAccess();
            if (this != Thread.currentThread()) {
                security.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        if (this.threadStatus != 0) {
            this.resume();
        }
        this.stop0(new ThreadDeath());
    }

    @Deprecated
    public final synchronized void stop(Throwable obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible b = this.blocker;
            if (b != null) {
                this.interrupt0();
                b.interrupt(this);
                return;
            }
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    @Deprecated
    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    @Deprecated
    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int newPriority) {
        this.checkAccess();
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        ThreadGroup g = this.getThreadGroup();
        if (g != null) {
            if (newPriority > g.getMaxPriority()) {
                newPriority = g.getMaxPriority();
            }
            this.priority = newPriority;
            this.setPriority0(this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final synchronized void setName(String name) {
        this.checkAccess();
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        if (this.threadStatus != 0) {
            this.setNativeName(name);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] tarray) {
        return Thread.currentThread().getThreadGroup().enumerate(tarray);
    }

    @Deprecated
    public native int countStackFrames();

    public final synchronized void join(long millis) throws InterruptedException {
        long base = System.currentTimeMillis();
        long now = 0L;
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (millis == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long delay;
            while (this.isAlive() && (delay = millis - now) > 0L) {
                this.wait(delay);
                now = System.currentTimeMillis() - base;
            }
        }
    }

    public final synchronized void join(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos >= 500000 || nanos != 0 && millis == 0L) {
            ++millis;
        }
        this.join(millis);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean on) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = on;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + group.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + ",]";
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(this.contextClassLoader, Reflection.getCallerClass());
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = cl;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        if (this != Thread.currentThread()) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            }
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            StackTraceElement[][] stackTraceArray = Thread.dumpThreads(new Thread[]{this});
            StackTraceElement[] stackTrace = stackTraceArray[0];
            if (stackTrace == null) {
                stackTrace = EMPTY_STACK_TRACE;
            }
            return stackTrace;
        }
        return new Exception().getStackTrace();
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            security.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threads = Thread.getThreads();
        StackTraceElement[][] traces = Thread.dumpThreads(threads);
        HashMap<Thread, StackTraceElement[]> m = new HashMap<Thread, StackTraceElement[]>(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            StackTraceElement[] stackTrace = traces[i];
            if (stackTrace == null) continue;
            m.put(threads[i], stackTrace);
        }
        return m;
    }

    private static boolean isCCLOverridden(Class<?> cl) {
        if (cl == Thread.class) {
            return false;
        }
        Thread.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        WeakClassKey key = new WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = Thread.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        return result;
    }

    private static boolean auditSubclass(final Class<?> subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != Thread.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] params = new Class[]{ClassLoader.class};
                            cl.getDeclaredMethod("setContextClassLoader", params);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return VM.toThreadState(this.threadStatus);
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = eh;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        this.checkAccess();
        this.uncaughtExceptionHandler = eh;
    }

    private void dispatchUncaughtException(Throwable e) {
        this.getUncaughtExceptionHandler().uncaughtException(this, e);
    }

    static void processQueue(ReferenceQueue<Class<?>> queue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> map) {
        Reference<Class<?>> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    private native void setNativeName(String var1);

    static {
        Thread.registerNatives();
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> cl, ReferenceQueue<Class<?>> refQueue) {
            super(cl, refQueue);
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakClassKey) {
                Object referent = this.get();
                return referent != null && referent == ((WeakClassKey)obj).get();
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

