/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Timestamp;
import java.security.cert.CertPath;

public final class CodeSigner
implements Serializable {
    private static final long serialVersionUID = 6819288105193937581L;
    private CertPath signerCertPath;
    private Timestamp timestamp;
    private transient int myhash = -1;

    public CodeSigner(CertPath signerCertPath, Timestamp timestamp) {
        if (signerCertPath == null) {
            throw new NullPointerException();
        }
        this.signerCertPath = signerCertPath;
        this.timestamp = timestamp;
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.timestamp == null ? this.signerCertPath.hashCode() : this.signerCertPath.hashCode() + this.timestamp.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CodeSigner)) {
            return false;
        }
        CodeSigner that = (CodeSigner)obj;
        if (this == that) {
            return true;
        }
        Timestamp thatTimestamp = that.getTimestamp();
        if (this.timestamp == null ? thatTimestamp != null : thatTimestamp == null || !this.timestamp.equals(thatTimestamp)) {
            return false;
        }
        return this.signerCertPath.equals(that.getSignerCertPath());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append("Signer: ").append(this.signerCertPath.getCertificates().get(0));
        if (this.timestamp != null) {
            sb.append("timestamp: ").append(this.timestamp);
        }
        sb.append(")");
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.signerCertPath == null) {
            throw new InvalidObjectException("signerCertPath is null");
        }
        this.myhash = -1;
    }
}

