/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;

public final class TemporalQueries {
    static final TemporalQuery<ZoneId> ZONE_ID = temporal -> temporal.query(ZONE_ID);
    static final TemporalQuery<Chronology> CHRONO = temporal -> temporal.query(CHRONO);
    static final TemporalQuery<TemporalUnit> PRECISION = temporal -> temporal.query(PRECISION);
    static final TemporalQuery<ZoneOffset> OFFSET = temporal -> {
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            return ZoneOffset.ofTotalSeconds(temporal.get(ChronoField.OFFSET_SECONDS));
        }
        return null;
    };
    static final TemporalQuery<ZoneId> ZONE = temporal -> {
        ZoneId zone = temporal.query(ZONE_ID);
        return zone != null ? zone : (ZoneId)temporal.query(OFFSET);
    };
    static final TemporalQuery<LocalDate> LOCAL_DATE = temporal -> {
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            return LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
        }
        return null;
    };
    static final TemporalQuery<LocalTime> LOCAL_TIME = temporal -> {
        if (temporal.isSupported(ChronoField.NANO_OF_DAY)) {
            return LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY));
        }
        return null;
    };

    private TemporalQueries() {
    }

    public static TemporalQuery<ZoneId> zoneId() {
        return ZONE_ID;
    }

    public static TemporalQuery<Chronology> chronology() {
        return CHRONO;
    }

    public static TemporalQuery<TemporalUnit> precision() {
        return PRECISION;
    }

    public static TemporalQuery<ZoneId> zone() {
        return ZONE;
    }

    public static TemporalQuery<ZoneOffset> offset() {
        return OFFSET;
    }

    public static TemporalQuery<LocalDate> localDate() {
        return LOCAL_DATE;
    }

    public static TemporalQuery<LocalTime> localTime() {
        return LOCAL_TIME;
    }
}

