/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

class EditableView
extends ComponentView {
    private boolean isVisible;

    EditableView(Element e) {
        super(e);
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (this.isVisible) {
            return super.getMinimumSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.isVisible) {
            return super.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        if (this.isVisible) {
            return super.getMaximumSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Component c = this.getComponent();
        Container host = this.getContainer();
        if (host instanceof JTextComponent && this.isVisible != ((JTextComponent)host).isEditable()) {
            this.isVisible = ((JTextComponent)host).isEditable();
            this.preferenceChanged(null, true, true);
            host.repaint();
        }
        if (this.isVisible) {
            super.paint(g, allocation);
        } else {
            this.setSize(0.0f, 0.0f);
        }
        if (c != null) {
            c.setFocusable(this.isVisible);
        }
    }

    @Override
    public void setParent(View parent) {
        Container host;
        if (parent != null && (host = parent.getContainer()) != null) {
            this.isVisible = host instanceof JTextComponent ? ((JTextComponent)host).isEditable() : false;
        }
        super.setParent(parent);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }
}

