/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.Path2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import sun.java2d.ReentrantContext;
import sun.java2d.marlin.ArrayCache;
import sun.java2d.marlin.ByteArrayCache;
import sun.java2d.marlin.CollinearSimplifier;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.Dasher;
import sun.java2d.marlin.FloatArrayCache;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderingEngine;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererStats;
import sun.java2d.marlin.Stroker;
import sun.java2d.marlin.TransformingPathConsumer2D;

final class RendererContext
extends ReentrantContext
implements MarlinConst {
    private static final AtomicInteger contextCount = new AtomicInteger(1);
    static final RendererStats stats = doStats ? RendererStats.getInstance() : null;
    private static final boolean USE_CACHE_HARD_REF = doStats || MarlinRenderingEngine.REF_TYPE == 2;
    final String name;
    boolean dirty = false;
    WeakReference<ArrayCachesHolder> refArrayCaches = null;
    ArrayCachesHolder hardRefArrayCaches = null;
    final float[] float6 = new float[6];
    final Curve curve = new Curve();
    final MarlinRenderingEngine.NormalizingPathIterator nPCPathIterator;
    final MarlinRenderingEngine.NormalizingPathIterator nPQPathIterator;
    final TransformingPathConsumer2D transformerPC2D;
    Path2D.Float p2d = null;
    final Renderer renderer;
    final Stroker stroker;
    final CollinearSimplifier simplifier = new CollinearSimplifier();
    final Dasher dasher;
    final MarlinTileGenerator ptg;
    final MarlinCache cache;
    int stroking = 0;

    static RendererContext createContext() {
        RendererContext newCtx = new RendererContext("ctx" + Integer.toString(contextCount.getAndIncrement()));
        if (stats != null) {
            RendererContext.stats.allContexts.add(newCtx);
        }
        return newCtx;
    }

    RendererContext(String name) {
        if (logCreateContext) {
            MarlinUtils.logInfo("new RendererContext = " + name);
        }
        this.name = name;
        this.nPCPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelCenter(this.float6);
        this.nPQPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelQuarter(this.float6);
        this.transformerPC2D = new TransformingPathConsumer2D();
        this.cache = new MarlinCache(this);
        this.renderer = new Renderer(this);
        this.ptg = new MarlinTileGenerator(this.renderer);
        this.stroker = new Stroker(this);
        this.dasher = new Dasher(this);
    }

    void dispose() {
        this.stroking = 0;
        if (!USE_CACHE_HARD_REF) {
            this.hardRefArrayCaches = null;
        }
        if (this.dirty) {
            this.nPCPathIterator.dispose();
            this.nPQPathIterator.dispose();
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    ArrayCachesHolder getArrayCachesHolder() {
        ArrayCachesHolder holder = this.hardRefArrayCaches;
        if (holder == null) {
            ArrayCachesHolder arrayCachesHolder = holder = this.refArrayCaches != null ? (ArrayCachesHolder)this.refArrayCaches.get() : null;
            if (holder == null) {
                if (logCreateContext) {
                    MarlinUtils.logInfo("new ArrayCachesHolder for RendererContext = " + this.name);
                }
                holder = new ArrayCachesHolder();
                if (USE_CACHE_HARD_REF) {
                    this.hardRefArrayCaches = holder;
                }
                this.refArrayCaches = new WeakReference<ArrayCachesHolder>(holder);
            }
        }
        return holder;
    }

    ByteArrayCache getDirtyByteArrayCache(int length) {
        int bucket = ArrayCache.getBucketDirtyBytes(length);
        return this.getArrayCachesHolder().dirtyByteArrayCaches[bucket];
    }

    byte[] getDirtyByteArray(int length) {
        if (length <= ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE) {
            return this.getDirtyByteArrayCache(length).getArray();
        }
        if (doStats) {
            ArrayCache.incOversize();
        }
        if (doLogOverSize) {
            MarlinUtils.logInfo("getDirtyByteArray[oversize]: length=\t" + length);
        }
        return new byte[length];
    }

    void putDirtyByteArray(byte[] array) {
        int length = array.length;
        if ((length & 1) == 0 && length <= ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE) {
            this.getDirtyByteArrayCache(length).putDirtyArray(array, length);
        }
    }

    byte[] widenDirtyByteArray(byte[] in, int usedSize, int needSize) {
        int length = in.length;
        if (doChecks && length >= needSize) {
            return in;
        }
        if (doStats) {
            ArrayCache.incResizeDirtyByte();
        }
        byte[] res = this.getDirtyByteArray(ArrayCache.getNewSize(usedSize, needSize));
        System.arraycopy(in, 0, res, 0, usedSize);
        this.putDirtyByteArray(in);
        if (doLogWidenArray) {
            MarlinUtils.logInfo("widenDirtyByteArray[" + res.length + "]: usedSize=\t" + usedSize + "\tlength=\t" + length + "\tneeded length=\t" + needSize);
        }
        return res;
    }

    IntArrayCache getIntArrayCache(int length) {
        int bucket = ArrayCache.getBucket(length);
        return this.getArrayCachesHolder().intArrayCaches[bucket];
    }

    int[] getIntArray(int length) {
        if (length <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getIntArrayCache(length).getArray();
        }
        if (doStats) {
            ArrayCache.incOversize();
        }
        if (doLogOverSize) {
            MarlinUtils.logInfo("getIntArray[oversize]: length=\t" + length);
        }
        return new int[length];
    }

    int[] widenIntArray(int[] in, int usedSize, int needSize, int clearTo) {
        int length = in.length;
        if (doChecks && length >= needSize) {
            return in;
        }
        if (doStats) {
            ArrayCache.incResizeInt();
        }
        int[] res = this.getIntArray(ArrayCache.getNewSize(usedSize, needSize));
        System.arraycopy(in, 0, res, 0, usedSize);
        this.putIntArray(in, 0, clearTo);
        if (doLogWidenArray) {
            MarlinUtils.logInfo("widenIntArray[" + res.length + "]: usedSize=\t" + usedSize + "\tlength=\t" + length + "\tneeded length=\t" + needSize);
        }
        return res;
    }

    void putIntArray(int[] array, int fromIndex, int toIndex) {
        int length = array.length;
        if ((length & 1) == 0 && length <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getIntArrayCache(length).putArray(array, length, fromIndex, toIndex);
        }
    }

    IntArrayCache getDirtyIntArrayCache(int length) {
        int bucket = ArrayCache.getBucket(length);
        return this.getArrayCachesHolder().dirtyIntArrayCaches[bucket];
    }

    int[] getDirtyIntArray(int length) {
        if (length <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getDirtyIntArrayCache(length).getArray();
        }
        if (doStats) {
            ArrayCache.incOversize();
        }
        if (doLogOverSize) {
            MarlinUtils.logInfo("getDirtyIntArray[oversize]: length=\t" + length);
        }
        return new int[length];
    }

    int[] widenDirtyIntArray(int[] in, int usedSize, int needSize) {
        int length = in.length;
        if (doChecks && length >= needSize) {
            return in;
        }
        if (doStats) {
            ArrayCache.incResizeDirtyInt();
        }
        int[] res = this.getDirtyIntArray(ArrayCache.getNewSize(usedSize, needSize));
        System.arraycopy(in, 0, res, 0, usedSize);
        this.putDirtyIntArray(in);
        if (doLogWidenArray) {
            MarlinUtils.logInfo("widenDirtyIntArray[" + res.length + "]: usedSize=\t" + usedSize + "\tlength=\t" + length + "\tneeded length=\t" + needSize);
        }
        return res;
    }

    void putDirtyIntArray(int[] array) {
        int length = array.length;
        if ((length & 1) == 0 && length <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getDirtyIntArrayCache(length).putDirtyArray(array, length);
        }
    }

    FloatArrayCache getDirtyFloatArrayCache(int length) {
        int bucket = ArrayCache.getBucket(length);
        return this.getArrayCachesHolder().dirtyFloatArrayCaches[bucket];
    }

    float[] getDirtyFloatArray(int length) {
        if (length <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getDirtyFloatArrayCache(length).getArray();
        }
        if (doStats) {
            ArrayCache.incOversize();
        }
        if (doLogOverSize) {
            MarlinUtils.logInfo("getDirtyFloatArray[oversize]: length=\t" + length);
        }
        return new float[length];
    }

    float[] widenDirtyFloatArray(float[] in, int usedSize, int needSize) {
        int length = in.length;
        if (doChecks && length >= needSize) {
            return in;
        }
        if (doStats) {
            ArrayCache.incResizeDirtyFloat();
        }
        float[] res = this.getDirtyFloatArray(ArrayCache.getNewSize(usedSize, needSize));
        System.arraycopy(in, 0, res, 0, usedSize);
        this.putDirtyFloatArray(in);
        if (doLogWidenArray) {
            MarlinUtils.logInfo("widenDirtyFloatArray[" + res.length + "]: usedSize=\t" + usedSize + "\tlength=\t" + length + "\tneeded length=\t" + needSize);
        }
        return res;
    }

    void putDirtyFloatArray(float[] array) {
        int length = array.length;
        if ((length & 1) == 0 && length <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getDirtyFloatArrayCache(length).putDirtyArray(array, length);
        }
    }

    static final class ArrayCachesHolder {
        final IntArrayCache[] intArrayCaches = new IntArrayCache[4];
        final IntArrayCache[] dirtyIntArrayCaches = new IntArrayCache[4];
        final FloatArrayCache[] dirtyFloatArrayCaches = new FloatArrayCache[4];
        final ByteArrayCache[] dirtyByteArrayCaches = new ByteArrayCache[4];

        ArrayCachesHolder() {
            for (int i = 0; i < 4; ++i) {
                this.intArrayCaches[i] = new IntArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyIntArrayCaches[i] = new IntArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyFloatArrayCaches[i] = new FloatArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyByteArrayCaches[i] = new ByteArrayCache(ArrayCache.DIRTY_BYTE_ARRAY_SIZES[i]);
            }
        }
    }
}

