/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.util.List;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.ccache.FileCredentialsCache;

public abstract class CredentialsCache {
    static CredentialsCache singleton = null;
    static String cacheName;
    private static boolean DEBUG;

    public static CredentialsCache getInstance(PrincipalName principal) {
        return FileCredentialsCache.acquireInstance(principal, null);
    }

    public static CredentialsCache getInstance(String cache) {
        if (cache.length() >= 5 && cache.substring(0, 5).equalsIgnoreCase("FILE:")) {
            return FileCredentialsCache.acquireInstance(null, cache.substring(5));
        }
        return FileCredentialsCache.acquireInstance(null, cache);
    }

    public static CredentialsCache getInstance(PrincipalName principal, String cache) {
        if (cache != null && cache.length() >= 5 && cache.regionMatches(true, 0, "FILE:", 0, 5)) {
            return FileCredentialsCache.acquireInstance(principal, cache.substring(5));
        }
        return FileCredentialsCache.acquireInstance(principal, cache);
    }

    public static CredentialsCache getInstance() {
        return FileCredentialsCache.acquireInstance();
    }

    public static CredentialsCache create(PrincipalName principal, String name) {
        if (name == null) {
            throw new RuntimeException("cache name error");
        }
        if (name.length() >= 5 && name.regionMatches(true, 0, "FILE:", 0, 5)) {
            name = name.substring(5);
            return FileCredentialsCache.New(principal, name);
        }
        return FileCredentialsCache.New(principal, name);
    }

    public static CredentialsCache create(PrincipalName principal) {
        return FileCredentialsCache.New(principal);
    }

    public static String cacheName() {
        return cacheName;
    }

    public abstract PrincipalName getPrimaryPrincipal();

    public abstract void update(sun.security.krb5.internal.ccache.Credentials var1);

    public abstract void save() throws IOException, KrbException;

    public abstract sun.security.krb5.internal.ccache.Credentials[] getCredsList();

    public abstract sun.security.krb5.internal.ccache.Credentials getDefaultCreds();

    public abstract Credentials getInitialCreds();

    public abstract sun.security.krb5.internal.ccache.Credentials getCreds(PrincipalName var1);

    public abstract sun.security.krb5.internal.ccache.Credentials getCreds(LoginOptions var1, PrincipalName var2);

    public abstract void addConfigEntry(ConfigEntry var1);

    public abstract List<ConfigEntry> getConfigEntries();

    public ConfigEntry getConfigEntry(String name) {
        List<ConfigEntry> entries = this.getConfigEntries();
        if (entries != null) {
            for (ConfigEntry e : entries) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
        }
        return null;
    }

    static {
        DEBUG = Krb5.DEBUG;
    }

    public static class ConfigEntry {
        private final String name;
        private final PrincipalName princ;
        private final byte[] data;

        public ConfigEntry(String name, PrincipalName princ, byte[] data) {
            this.name = name;
            this.princ = princ;
            this.data = data;
        }

        public String getName() {
            return this.name;
        }

        public PrincipalName getPrinc() {
            return this.princ;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.name + (this.princ != null ? "." + this.princ : "") + ": " + new String(this.data);
        }

        public PrincipalName getSName() {
            try {
                return new PrincipalName("krb5_ccache_conf_data/" + this.name + (this.princ != null ? "/" + this.princ : "") + "@X-CACHECONF:");
            }
            catch (RealmException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

