/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAUtil;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509Key;

public final class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey {
    private static final long serialVersionUID = 2644735423591199609L;
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private BigInteger n;
    private BigInteger e;
    private AlgorithmParameterSpec keyParams;

    public static RSAPublicKey newKey(byte[] encoded) throws InvalidKeyException {
        return new RSAPublicKeyImpl(encoded);
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType type, AlgorithmParameterSpec params, BigInteger n, BigInteger e) throws InvalidKeyException {
        AlgorithmId rsaId = RSAUtil.createAlgorithmId(type, params);
        return new RSAPublicKeyImpl(rsaId, n, e);
    }

    RSAPublicKeyImpl(AlgorithmId rsaId, BigInteger n, BigInteger e) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(n.bitLength(), e);
        RSAPublicKeyImpl.checkExponentRange(n, e);
        this.n = n;
        this.e = e;
        this.keyParams = RSAUtil.getParamSpec(rsaId);
        this.algid = rsaId;
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(n);
            out.putInteger(e);
            byte[] keyArray = new DerValue(48, out.toByteArray()).toByteArray();
            this.setKey(new BitArray(keyArray.length * 8, keyArray));
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    RSAPublicKeyImpl(byte[] encoded) throws InvalidKeyException {
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        this.decode(encoded);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
        RSAPublicKeyImpl.checkExponentRange(this.n, this.e);
        try {
            this.keyParams = RSAUtil.getParamSpec(this.algid);
        }
        catch (ProviderException e) {
            throw new InvalidKeyException(e);
        }
    }

    static void checkExponentRange(BigInteger mod, BigInteger exp) throws InvalidKeyException {
        if (exp.compareTo(mod) >= 0) {
            throw new InvalidKeyException("exponent is larger than modulus");
        }
        if (exp.compareTo(THREE) < 0) {
            throw new InvalidKeyException("exponent is smaller than 3");
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            this.n = data.getPositiveBigInteger();
            this.e = data.getPositiveBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid RSA public key", e);
        }
    }

    @Override
    public String toString() {
        return "Sun " + this.getAlgorithm() + " public key, " + this.n.bitLength() + " bits\n  params: " + this.keyParams + "\n  modulus: " + this.n + "\n  public exponent: " + this.e;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPublicKeyImpl keys are not directly deserializable");
    }
}

