/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.Security;

public class SecurityProperties {
    public static String privilegedGetOverridable(String propName) {
        if (System.getSecurityManager() == null) {
            return SecurityProperties.getOverridableProperty(propName);
        }
        return AccessController.doPrivileged(() -> SecurityProperties.getOverridableProperty(propName));
    }

    private static String getOverridableProperty(String propName) {
        String val = System.getProperty(propName);
        if (val == null) {
            return Security.getProperty(propName);
        }
        return val;
    }

    public static boolean includedInExceptions(String refName) {
        String[] tokens;
        String val = SecurityProperties.privilegedGetOverridable("jdk.includeInExceptions");
        if (val == null) {
            return false;
        }
        for (String token : tokens = val.split(",")) {
            if (!(token = token.trim()).equalsIgnoreCase(refName)) continue;
            return true;
        }
        return false;
    }
}

