<?php

namespace Adfox\Appearance\Filament\Resources;

use Adfox\Appearance\Filament\Resources\BannerResource\Pages;
use Adfox\Appearance\Filament\Resources\BannerResource\RelationManagers;
use Adfox\Appearance\Traits\LocationFormFields;
use App\Filament\Clusters\DesignAppearance;
use App\Models\Banner;
use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Get;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Adfox\Appearance\Traits\BannerFormFields;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\RichEditor;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;



class BannerResource extends Resource implements HasShieldPermissions
{
    use LocationFormFields,BannerFormFields;

    protected static ?string $model = Banner::class;

    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-squares-plus';

    public static function getModelLabel(): string
    {
        return __('messages.t_ap_banner');
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'create',
            'update',
            'view_any',
            'delete_any',
            'view_report'
        ];
    }

    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_banner');
    }

    public static function canCreate(): bool
    {
        return userHasPermission('create_banner');
    }

    public static function canEdit($record): bool
    {
        return userHasPermission('update_banner');
    }

    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_banner');
    }


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                FileUpload::make('image')
                    ->maxSize(maxUploadFileSize())
                    ->image()
                    ->imageEditor()
                    ->required()
                    ->label(__('messages.t_ap_image'))
                    ->helperText(__('messages.t_ap_recommended_image_size'))
                    ->columnSpanFull(),
                TextInput::make('alternative_text')
                    ->label(__('messages.t_ap_alternative_text')),
                ...self::getLocationFormFields(),
                ...self::getBannerFormFields(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->modifyQueryUsing(fn(Builder $query) => $query->orderBy('order', 'asc'))
            ->reorderable('order')
            ->columns([
                // TextColumn::make('name'),
                ImageColumn::make('image')
                    ->label(__('messages.t_ap_image')),
                TextColumn::make('')
                    ->label(__('messages.t_ap_view_count'))
                    ->default(function ($record) {
                        $count = Banner::whereId($record->id)->withCount([
                            'bannerAnalytics as views_count' => function (Builder $query) {
                                $query->where('event', 'view');
                            }
                        ])->first();
                        return $count->views_count ?? 0;
                    }),
                TextColumn::make('banner_analytics_count')
                    ->label(__('messages.t_ap_click_count'))
                    ->counts([
                        'bannerAnalytics' => fn(Builder $query) => $query->where('event', 'click'),
                    ]),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\Action::make('view_report')
                ->visible(fn () => userHasPermission('view_report_banner'))
                    ->label(__('messages.t_ap_view_report'))
                    ->icon('heroicon-o-chart-bar')
                    ->url(fn($record) => static::getUrl('report', ['record' => $record])),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBanners::route('/'),
            'create' => Pages\CreateBanner::route('/create'),
            'edit' => Pages\EditBanner::route('/{record}/edit'),
            'report' => Pages\ReportBanner::route('/{record}/report'),
        ];
    }
}
