<div>
    <!-- Skip links -->
    @include('components.skip-links',['links'=>[
        'main-content'=> __('messages.t_skip_to_main_content')
    ]])
    <livewire:layout.header isMobileHidden lazy />
    <main id="main-content" class="sticky-scroll-margin">
    <x-page-header title="{{ __('messages.t_blogs') }}" isMobileHidden :$referrer />

    <div
        class="hidden md:block py-4 md:py-6 bg-gray-200 dark:bg-gray-800 classic:bg-gray-50  classic:border-y border-black">
        <div class="container mx-auto px-4">
            <h1 class="text-3xl font-bold tracking-tight text-gray-900 dark:text-white ">
                {{ __('messages.t_blogs') }}
            </h1>
        </div>
    </div>

    <div class=" pt-6 pb-24 md:pt-10 md:pb-10">
        <div class="mx-auto container leading-7 px-4 flex flex-col-reverse md:grid md:grid-cols-12 gap-6">
            <div class="col-span-12 md:col-span-9" >
            <div
                class=" grid grid-cols-1 sm:grid-cols-2  md:grid-cols-3 lg:grid-cols-3 xl:grid-cols-4 gap-4 md:gap-6">
                @forelse ($articles as $article)
                <div wire:key='article-{{$article->id}}'
                    class="flex flex-col rounded-xl border shadow-sm overflow-hidden border-gray-200 dark:border-white/10 classic:border-black">
                    <a tabindex="-1" href="{{ route('blog.post', ['slug' => $article->slug]) }}" class="flex-shrink-0">
                        <img class="h-48 w-full object-cover lazy" src="{{ $article->image }}"
                            alt="{{ $article->title }}">
                    </a>
                    <div class="flex-1 bg-white dark:bg-zinc-800 p-6 flex flex-col justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500">
                                {{ __('messages.t_x_min_read', ['x' => $article->reading_time]) }}
                            </p>
                            <a href="{{ route('blog.post', ['slug' => $article->slug]) }}"
                                class="block mt-2" style="text-overflow: ellipsis;">
                                <p class="text-base font-semibold text-gray-900 dark:text-gray-200 hover:text-primary-600 truncate">
                                    {{ $article->title }}</p>
                            </a>
                        </div>
                    </div>
                </div>
                @empty
                <x-not-found description="{{ __('messages.t_no_blog_found') }}" />
                @endforelse
            </div>
            {{-- Pagination --}}
            @if ($articles->hasPages())
            <div class="w-full flex justify-center items-center mt-24">
                {!! $articles->links('pagination::tailwind') !!}
            </div>
            @endif
            </div>


            <div class="mx-auto container  md:block col-span-3 leading-7 md:ps-4 " x-data="{
                showFilter:false
            }">
                <div class="flex gap-5 w-full items-center justify-between">

                    <div class="blog-search flex-grow">
                        <x-filament::input.wrapper>
                            <x-filament::input type="text" class=" indent-2" wire:model="search"
                                wire:keydown.enter="performSearch" placeholder="{{ __('messages.t_search_blog') }}" />
                            <x-slot name="suffix">
                                <x-filament::icon-button icon="search" wire:click="performSearch" label="{{__('messages.t_aria_label_search')}}" />
                            </x-slot>
                        </x-filament::input.wrapper>
                    </div>
                    <div x-on:click="showFilter=!showFilter; document.body.style.overflow = 'hidden'"
                        class=" md:hidden">
                        <x-icon-filter class="w-6 h-6 dark:text-gray-400 cursor-pointer" />
                    </div>
                </div>
                <div x-show='showFilter' x-cloak
                    class=" fixed inset-0 h-full bg-white rounded-lg shadow-sm dark:bg-gray-800 classic:bg-gray-50 dark:text-slate-300 ">
                    <div class="bg-white dark:bg-zinc-800 z-50">
                        <div class="flex justify-between items-center py-3 px-4 border-b border-black dark:border-white/10 mb-4 md:hidden">
                            <p class="text-lg">{{__('messages.t_blog_category')}} </p>
                            <div x-on:click="showFilter=false; document.body.style.overflow = 'auto'">
                                <x-icon-close class="w-4 h-4 cursor-pointer" />
                            </div>
                        </div>

                        <ul>
                        @foreach ($categories as $category)
                        <li>
                            <button type="button" class="w-full cursor-pointer hover:text-primary-600 flex px-4 justify-between items-center {{$category->slug==$mainCategory? 'font-bold':''}}"
                                wire:key='article-category-{{$category->slug}}'
                                x-on:click="$wire.selectMainCategory('{{$category->slug}}');showFilter=false;">
                                <span class="{{$category->slug==$mainCategory? 'font-bold':''}}">{{$category->name}}</span>
                                @if ($category->slug==$mainCategory)
                                <x-heroicon-o-x-mark class="w-5 h-5" />
                                @endif
                            </button>
                        </li>
                        @endforeach
                        </ul>
                    </div>

                </div>
                <div
                    class="my-4 hidden md:block bg-white rounded-lg shadow-sm border-gray-950/5 dark:bg-gray-800 classic:bg-gray-50  border classic:border-black   dark:text-slate-300 ">
                    <h2 class="font-semibold py-3 px-5 border-b   classic:border-black  dark:border-white/10">
                        {{__('messages.t_blog_category')}}</h2>

                    <ul class="py-3 px-5">
                        @foreach ($categories as $category)
                        <li>
                            <button type="button" class="w-full cursor-pointer hover:text-primary-600 flex justify-between items-center {{$category->slug==$mainCategory? 'font-bold':''}}"
                                wire:key='article-category-{{$category->slug}}'
                                wire:click="selectMainCategory('{{$category->slug}}')">
                            <span >{{$category->name}}</span>
                            @if ($category->slug==$mainCategory)
                            <x-heroicon-o-x-mark class="w-5 h-5" />
                            @endif
                            </button>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    </main>
    <livewire:layout.footer />

    <livewire:layout.bottom-navigation />
</div>
