<?php

namespace Adfox\Blog;

use Filament\Panel;
use Filament\Contracts\Plugin;

class BlogPlugin implements Plugin
{
    public function getId(): string
    {
        return 'blog';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Blog\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Blog\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
