<?php

namespace Adfox\ECommerce\Filament\App\Resources\WarehouseResource\RelationManagers;

use App\Settings\UserSettings;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class StockTransactionRelationManager extends RelationManager
{
    protected static string $relationship = 'stock_transactions';
    public $adId;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    // public function mount(): void
    // {
    //     $this->adId = request()->get('adId'); // Fetch from URL or other input
    //     dd(request('adId'));
    // }

    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->modifyQueryUsing(fn(Builder $query) => $query)
            ->columns([
                SpatieMediaLibraryImageColumn::make('ad.ads')
                    ->collection('ads')
                    ->conversion('thumb')
                    ->defaultImageUrl(fn($record)=>getAdPlaceholderImage($record->ad?->id))
                    ->label(__('messages.t_ad_images'))
                    ->size(40)
                    ->circular()
                    ->overlap(2)
                    ->stacked()
                    ->limit(3),
                TextColumn::make('ad.title')
                    ->limit(app(UserSettings::class)?->max_character ?? 45)
                    ->tooltip(function (TextColumn $column): ?string {
                        $state = $column->getState();

                        if (strlen($state) <= $column->getCharacterLimit()) {
                            return null;
                        }

                        // Only render the tooltip if the column content exceeds the length limit.
                        return $state;
                    })
                    ->label(__('messages.t_ad_title'))
                    ->searchable(),
                TextColumn::make('transaction_type')->searchable(),
                TextColumn::make('quantity'),
                TextColumn::make('transaction_date')->searchable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                // Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->emptyStateActions([]);
    }
}
