<?php

namespace Adfox\ECommerce\Livewire\Payment;

use App\Traits\HelperTraits;
use Livewire\Component;
use App\Settings\PaymentSettings;
use App\Settings\FlutterwaveSettings;
use App\Settings\GeneralSettings;

class Flutterwave extends Component
{
    use HelperTraits;

    public $totalAmount;

    /**
     * Mount the component and process payment.
     */
    public function mount()
    {
        $this->processPayment();
    }

    /**
     * Access payment settings.
     */
    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    /**
     * Access general settings.
     */
    public function getGeneralSettingsProperty()
    {
        return app(GeneralSettings::class);
    }

    /**
     * Access Flutterwave settings.
     */
    public function getFlutterwaveSettingsProperty()
    {
        return app(FlutterwaveSettings::class);
    }

    /**
     * Process payment and set gateway parameters.
     */
    public function processPayment()
    {
        // Retrieve the current temporary order from session
        $orderId = session('current_temporary_order');

        // Set payment parameters
        $this->payment_gateway_params = [
            'order_id' => $orderId
        ];
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('e-commerce::payment.flutterwave');
    }
}
