<?php

namespace Adfox\ECommerce\Livewire\Payment;

use App\Traits\HelperTraits;
use App\Settings\PaypalSettings;
use Livewire\Component;

class Paypal extends Component
{
    use HelperTraits;

    public $totalAmount;

    public function mount()
    {
        $this->payment_gateway_params['order_id'] = session()->get('current_temporary_order');
    }

    public function getPaypalSettingsProperty()
    {
        return app(PaypalSettings::class);
    }

    public function render()
    {
        return view('e-commerce::payment.paypal');
    }
}
