<?php

namespace Adfox\ECommerce\Providers;

use Adfox\ECommerce\ECommercePlugin;
use Adfox\ECommerce\Livewire\Product\Post\ProductFieldDetail;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Livewire\Livewire;

class ECommerceServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new ECommercePlugin()));
    }

    public function boot()
    {
        Livewire::component('ecommerce.product-field-detail', ProductFieldDetail::class);
    }

}
