<div class="mt-4">
    <p class="mb-4">{{ __('messages.t_confirm_location_postal_code') }}</p>


    <x-input-error :messages="$errors->get('locationName')" class="mb-4" />

    <div class="rounded-b" x-data>
        <div class="relative">
            <input wire:model.debounce.500='locationName' id="location-input" type="text" name="search"
                placeholder="{{ __('messages.t_type_location_prompt') }}"
                class="focus:ring-primary-600 focus:ring-2  focus:border-none w-full px-4 py-3 border border-gray-200 rounded rounded-b-none bg-white dark:bg-gray-900  dark:border-white/10 classic:border-black"
                @input="$store.postad.updateLocations($event.target.value)">
            @if ($locationName)
                <button type="button" aria-label="{{__('messages.t_aria_label_clear')}}"  wire:click="$set('locationName', '')"
                    class="p-2 absolute right-2 top-1.5 bg-white dark:bg-gray-900">
                    <x-heroicon-o-x-mark class="w-6 h-6" />
                </button>
            @endif
        </div>
        <div
            class="focus-within:relative border-x border-b border-gray-200 rounded-b bg-white dark:bg-gray-900 dark:border-white/10 classic:border-black">
            <!-- Current Location Section -->
            <button aria-label="{{__('messages.t_aria_label_use_current_location')}}" type="button" @click="$store.postad.getLocation($wire)" class="flex items-center  gap-x-2 px-4 py-3 cursor-pointer">
                <x-icon-location class="w-6 h-6" />
                <div class="text-left">
                    <span>{{ __('messages.t_use_current_location') }}</span>
                    <div x-data="{ locationBlocked: @entangle('locationBlocked') }" class="text-gray-400 text-sm" x-show="locationBlocked">
                        {{ __('messages.t_location_blocked') }}</div>
                </div>
            </button>
            <!-- Locations from Google -->
            <div class="px-4 border-t border-gray-200  dark:border-white/10 classic:border-black"
                x-show="$store.postad.locations && $store.postad.locations.length > 0">
                <template x-for="location in $store.postad.locations" :key="location.description">
                    <button type="button" @click="$store.postad.selectLocation(location.place_id, $wire, 'post-ad')"
                        class="text-left flex items-center my-4 cursor-pointer">
                        <span class="ml-2" x-text="location.description"></span>
                    </button>
                </template>
            </div>
        </div>
    </div>
</div>

@assets
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{ $this->googleSettings?->api_key }}&libraries=places&language={{ str_replace('_', '-', app()->getLocale()) }}">
    </script>
@endassets

@script
    <script>
        Alpine.store('postad', {
            open: false,
            locations: [],
            getLocation(wire) {
                navigator.geolocation.getCurrentPosition(position => {
                    const latitude = position.coords.latitude;
                    const longitude = position.coords.longitude;
                    const GOOGLE_API_KEY = "{{ $this->googleSettings?->api_key }}";
                    // Call the geocoding API to fetch the location name
                    fetch(
                            `https://maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=${GOOGLE_API_KEY}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.results && data.results.length > 0) {
                                const addressComponents = data.results[0].address_components;
                                const city = addressComponents.find(comp => comp.types.includes('locality') ||
                            comp.types.includes('administrative_area_level_3') ||
                            comp.types.includes('postal_town') ||
                            comp.types.includes('sublocality_level_1') ||
                            comp.types.includes('administrative_area_level_2'))?.short_name;
                                const state = addressComponents.find(comp => comp.types.includes(
                                    'administrative_area_level_1'))?.short_name;
                                const postalCode = addressComponents.find(comp => comp.types.includes(
                                    'postal_code'))?.short_name;
                                const country = addressComponents.find(comp => comp.types.includes(
                                    'country'))?.long_name;
                                const area = addressComponents.find(comp => comp.types.includes(
                                        'sublocality') || comp.types.includes('route') || comp.types
                                    .includes('sublocality_level_1') || comp.types.includes(
                                        'neighborhood'))?.short_name;
                                const locationName = this.formatLocation(area, city, state);

                                wire.set('latitude', latitude);
                                wire.set('longitude', longitude);
                                wire.set('locationName',
                                locationName); // Set the location name in the component
                                wire.set('locationBlocked', false);
                                wire.set('city', city);
                                wire.set('state', state);
                                wire.set('country', country);
                                wire.set('postal_code', postalCode);
                                if(!city){
                                    alert("{{__('messages.t_city_not_found')}}");
                                }
                            }
                        })
                        .catch(error => {
                            console.error("Error fetching the location name:", error);
                        });

                }, () => {
                    wire.set('locationBlocked', true);
                });
            },
            updateLocations(inputValue) {
                var allowedCountries = @json($this->locationSettings->allowed_countries);

                if (!inputValue) {
                    this.locations = [];
                    $wire.dispatch('required-fields-filled', {
                        isFilled: false
                    });
                    return;
                }
                // Get place predictions
                const service = new google.maps.places.AutocompleteService();
                service.getPlacePredictions({
                    input: inputValue,
                    componentRestrictions: {
                        country: allowedCountries
                    }
                }, (predictions, status) => {
                    if (status === google.maps.places.PlacesServiceStatus.OK) {
                        this.locations = predictions;
                    }
                });
            },
            selectLocation(placeId, wire, type) {
                const service = new google.maps.places.PlacesService(document.getElementById('location-input'));


                service.getDetails({
                    placeId: placeId
                }, (place, status) => {
                    if (status === google.maps.places.PlacesServiceStatus.OK) {
                        const latitude = place.geometry.location.lat();
                        const longitude = place.geometry.location.lng();
                        // Extract required components from address components
                        const addressComponents = place.address_components;
                        const city = addressComponents.find(comp => comp.types.includes('locality') ||
                            comp.types.includes('administrative_area_level_3') ||
                            comp.types.includes('postal_town') ||
                            comp.types.includes('sublocality_level_1') ||
                            comp.types.includes('administrative_area_level_2'))?.short_name;
                        const postalCode = addressComponents.find(comp => comp.types.includes(
                            'postal_code'))?.short_name;
                        const state = addressComponents.find(comp => comp.types.includes(
                            'administrative_area_level_1'))?.short_name;
                        const country = addressComponents.find(comp => comp.types.includes('country'))
                            ?.long_name;
                        const area = addressComponents.find(comp => comp.types.includes('sublocality') ||
                            comp.types.includes('route') || comp.types.includes(
                            'sublocality_level_1') || comp.types.includes('neighborhood'))?.short_name;
                        const locationName = this.formatLocation(area, city, state);
                        let locationType;
                        if (area) {
                            locationType = 'area';
                        } else if (city) {
                            locationType = 'city';
                        } else if (state) {
                            locationType = 'state';
                        } else if (country) {
                            locationType = 'country';
                        }

                        wire.set('locationName', locationName);
                        wire.set('latitude', latitude);
                        wire.set('longitude', longitude);
                        wire.set('city', city);
                        wire.set('state', state);
                        wire.set('country', country);
                        wire.set('postal_code', postalCode);
                        if(!city){
                            alert("{{__('messages.t_city_not_found')}}");
                        }
                    }
                });
            },
            formatLocation(area, city, state) {
                let location = '';
                if (area) location += area;
                if (city) location += area ? `, ${city}` : city;
                if (state) location += (area || city) ? ` - ${state}` : state;
                return location;
            }
        });
    </script>
@endscript
