<div >


    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <x-brand />

        <a href="/" class="hover:underline text-lg flex items-center gap-x-2" wire:navigate>
            <span>
                <x-heroicon-o-arrow-left class="w-5 h-5 cursor-pointer" />
            </span>
            {{ __('messages.t_back_to_home') }}
        </a>
    </div>


    <!-- Login Title -->
    <h1 class="text-2xl md:text-3xl mt-12 mb-8 font-semibold">{{ __('messages.t_otp_verification') }}</h1>
    <div>{{ __('messages.t_otp_description') }}</div>

    <form id="form" class="space-y-6" wire:submit='loginWithOtp'>
        @csrf
        <div class="space-y-1">
            <x-label for="mobile" :value="__('messages.t_enter_otp')" />
            <div class="mt-1">
                <x-filament::input.wrapper wire:ignore>

                    <x-filament::input required wire:model='otp' type="number" name="otp" autofocus class="w-full" />
                </x-filament::input.wrapper>



                <div class="alert alert-info" style="display: none;"></div>

            </div>
        </div>

<!-- Error message -->
        <div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">@error('otp') {{ $message }} @enderror</div>

        <!-- feedback message -->
        @if (session('status') == 'otp-incorrect')
        <div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">
            {{ __('
            Your OTP is not correct.') }}
        </div>
        @elseif (session('status') == 'otp-expired')
        <div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">
            {{ __('
            Your OTP has been expired.') }}
        </div>
      @endif

        @if (session('status') == 'otp-failed')
        <div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">
            {{ __('
            We apologize for the inconvenience you are experiencing with our OTP (One-Time Password) delivery.') }}
        </div>
        @endif
        @if (session('status') == 'otp-success' )
        <div class="mb-4 font-medium text-sm text-slate-600 dark:text-gray-200">
            <img src="/images/tick-circle-solid.svg" alt="" class="inline">
            {{ __('
           A new OTP has been sent to your mobile number.') }}
        </div>
        @endif

        <div>
            <x-button.secondary size="lg" class="block w-full dark:bg-primary-600 ">
                {{ __('messages.t_sign_in_action') }}
            </x-button.secondary>
        </div>

        <div>
            <p class="text-sm text-center text-slate-600 dark:text-gray-200">
                {{ __('messages.t_already_have_account') }}
                <a href="{{ route('login') }}" class="font-medium  underline">
                    {{ __('messages.t_login') }}
                </a>
            </p>
        </div>
        <div role="button" class="font-medium  underline text-center cursor-pointer" wire:click="$dispatch('resend-otp')">
            {{ __('messages.t_resend_otp_action') }}
        </div>
    </form>

</div>
