<?php

namespace Adfox\LoginOtp\Providers;

use Adfox\LoginOtp\Livewire\SendOtp;
use Adfox\LoginOtp\Livewire\VerificationOtp;
use Adfox\LoginOtp\Livewire\VerificationSendOtp;
use Adfox\LoginOtp\Livewire\VerifyOtp;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\LoginOtp\LoginOtpPlugin;
use Livewire\Livewire;

class LoginOtpServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new LoginOtpPlugin()));
    }

    public function boot()
    {
        Livewire::component('livewire.send-otp ', SendOtp::class);
        Livewire::component('livewire.verify-otp ', VerifyOtp::class);
        Livewire::component('livewire.verification-send-otp ', VerificationSendOtp::class);
        Livewire::component('livewire.verification-otp ', VerificationOtp::class);

        Relation::morphMap([]);

    }

}
