<?php

namespace Adfox\Mollie\Livewire;

use App\Models\WebhookPackage;
use Filament\Notifications\Notification;
use Livewire\Component;
use App\Models\WebhookUpgrade;
use App\Settings\PaymentSettings;
use App\Settings\GeneralSettings;
use App\Settings\MollieSettings;
use Mollie\Api\MollieApiClient;
class MolliePayment extends Component
{


    public $id;

    public $type;

    public $total;

    public $data;

    public $tax;

    public $subtotal;

    public $successUrl;

    public $payment_gateway_params = [];

    /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount($id)
    {

        $this->id = $id;
        $this->successUrl=url('/callback/mollie');
        $this->processPayment();
    }

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    public function getGeneralSettingsProperty()
    {
        return app(GeneralSettings::class);
    }

    public function getMollieSettingsProperty()
    {
        return app(MollieSettings::class);
    }

    public function processPayment()
    {

        // Generate order id for PayPal
        $order_id = $this->type . '-' . uid(18);

        // Set PayPal payment parameters
        $this->payment_gateway_params['order_id'] = $order_id;


        $this->makeMolliePayment($order_id);
        $this->handleWebhookUpgrade($order_id);

    }

    protected function handleWebhookUpgrade($order_id)
    {
        try {
            if ($this->type == 'PKG') {
                WebhookPackage::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $order_id,
                    'payment_method' => 'mollie',
                    'status' => 'pending'
                ]);
            } else {
                WebhookUpgrade::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $order_id,
                    'payment_method' => 'mollie',
                    'status' => 'pending'
                ]);
            }
        } catch (\Throwable $th) {
            // Handle any exceptions
        }
    }


    public function makeMolliePayment($order_id)
    {

        try {
            $mollie= new MollieApiClient();
            // Set api key
            $mollie->setApiKey( $this->mollieSettings->api_key);

            //Make Payment
            $payment = $mollie->payments->create([
                    "amount" => [
                        "currency" => $this->mollieSettings->currency ?? "EUR",
                        "value" => strval(number_format($this->total,2)),
                    ],
                    "method" => [
                        "applepay", "bancontact", "banktransfer", "belfius", "creditcard",
                        "directdebit", "eps", "giftcard", "giropay", "ideal", "kbc",
                        "mybank", "paypal", "paysafecard", "przelewy24", "sofort"
                    ],
                    "description" => $this->type == 'UG' ? 'Ad Upgrades' : 'Package Purchase',
                    "redirectUrl" => $this->successUrl,
                    "metadata" => [
                        "order_id" => $order_id,
                    ],
                ]);

                $paymentId=$payment->id;
                //Update redirect Url
                $payment = $mollie->payments->update(
                    $payment->id,
                    [
                        "redirectUrl" => $this->successUrl . '?payment_id=' . $paymentId,
                    ],
                );
                //Redirect to Checkout Url
                return redirect($payment->getCheckoutUrl(), 303);

            } catch (\Exception $e) {
                // Here, you can catch and handle the exception
                $response = $e->getMessage();

                // Consider using Notification to show error message
                Notification::make()
                    ->title('Error initiating payment: ' . $response)
                    ->danger()
                    ->send();
            }

    }
       /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('mollie::mollie-payment');
    }
}
