<?php
namespace Adfox\Subscription\Filament\App\Pages;

use App\Settings\PaymentSettings;
use App\Settings\SubscriptionSettings;
use Exception;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Support\Facades\Schema;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;

class ChoosePlan extends Page
{
    protected static string $view = 'subscription::plan.choose-plan';
    protected static ?int $navigationSort = 2;
    // protected static bool $shouldRegisterNavigation = false;

    #[Url]
    public $current = 'plan-details';

    public $plans = [];
    public $fromUrl;
    public $steps = [
        'plan-details',
        'plan-payment',
    ];
    public $planDetails = [];


    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_engagements_navigation');
    }
    public static function getNavigationLabel(): string
    {
        return __('messages.t_choose_plan');
    }
    public function getTitle(): string | Htmlable    {
        return __('messages.t_choose_plan');
    }

    public function mount()
    {
        $this->fromUrl=url()->previous();
        abortIfSubscriptionDisabled();
    }

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }


    #[On('select-plan')]
    public function selectPlan($price,$planId,$ad_count,$featured_ad_count,$urgent_ad_count,$spotlight_ad_count,$website_url_count)
    {
        $this->planDetails=[
            'price'=>$price,
            'plan_id'=>$planId,
            'ad_count'=>$ad_count,
            'featured_ad_count'=>$featured_ad_count,
            'urgent_ad_count'=> $urgent_ad_count,
            'spotlight_ad_count'=> $spotlight_ad_count,
            'website_url_count'=> $website_url_count,
        ];
        $this->next();

    }

 /**
     * Update the Current.
     *
     * @param string $current
     */
    #[On('current-step')]
    public function updateCurrentStep($current)
    {
        $this->current = $current;
    }

    public function redirectBack(){
        $this->back();
    }

    #[On('next-step')]
    public function next()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex !== false && isset($this->steps[$currentIndex + 1])) {
            $this->current = $this->steps[$currentIndex + 1];
        }
    }

    /**
     * Move to the previous step or redirect to home if at the first step.
     */
    public function back()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex === 0) {
            // Redirect to home if at the first step
            return redirect($this->fromUrl??route('home'));
        }

        if ($currentIndex !== false && isset($this->steps[$currentIndex - 1])) {
            $this->current = $this->steps[$currentIndex - 1];
        }
    }

    /**
     * Check if the page should be discovered.
     *
     * @return bool
     */
    public static function isDiscovered(): bool
    {
        try {
            $subscriptionSettings = app(SubscriptionSettings::class);
            return app('filament')->hasPlugin('subscription')
                && Schema::hasTable('settings')
                && $subscriptionSettings->status
              ;
        } catch (Exception $ex) {
            return false;
        }
    }

    //TODO : CREATE STRIPE PRODUCT AND PRICE
    // public function getPriceId()
    // {
    //     $stripe = new StripeClient($this->paymentGatewaySettings?->secret_key);
    //     $priceIds = $stripe->prices->all();
    //     dd($priceIds->first());
    //     $this->createCheckoutSession($priceIds->first());
    // }

    // public function createProductAndPrice($plan)
    // {
    //     // Set Stripe API key
    //     $stripe = new StripeClient($this->paymentGatewaySettings?->secret_key);
    //     // Create a new product
    //     $product=$stripe->products->create([
    //         'name' => $plan->name,
    //         'description' => $plan->description,
    //     ]);

    //     $price=$stripe->prices->create([
    //         'product' => $product->id,
    //         'unit_amount' => $plan->price*100,
    //         'currency' => $this->paymentGatewaySettings?->currency,
    //         'recurring' => [
    //             'interval' => $plan->invoice_interval,
    //             'interval_count'=>$plan->invoice_period
    //         ],
    //     ]);

    //     return response()->json([
    //         'product_id' => $product->id,
    //         'price_id' => $price->id,
    //     ]);
    // }

    // public function upComingInvoice(){
    //     $stripe = new \Stripe\StripeClient($this->paymentGatewaySettings?->secret_key);
    //     $upcomingInvoices=$stripe->invoices->upcoming(['subscription' => 'sub_1PVAEbGgztvb8gyCaiPmSAYA']);
    //     dd($upcomingInvoices);
    // }
}
