<?php

namespace Adfox\Subscription\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Filament\Notifications\Notification as FilamentNotification;

class UpcomingRenewalNotification extends Notification
{
    use Queueable;

    public $subscription;
    public $user;
    /**
     * Create a new notification instance.
     */
    public function __construct($user,$subscription)
    {
        $this->subscription=$subscription;
        $this->user=$user;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject(trans('messages.t_et_upcoming_subscription_renewal_subject'))
        ->line(trans('messages.t_et_dear_user', ['userName' => $this->user->name]))
        ->line(trans('messages.t_et_upcoming_subscription_renewal_body', ['planName' => $this->subscription->plan->name, 'renewalDate' => $this->subscription->ends_at->toFormattedDateString()]))
        ->line(trans('messages.t_et_thank_you_message'));    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        $notificationTitle = trans('messages.t_et_upcoming_subscription_renewal_subject');
        $notificationBody = trans('messages.t_et_upcoming_subscription_renewal_body', ['planName' => $this->subscription->plan->name, 'renewalDate' => $this->subscription->ends_at->toFormattedDateString()]);


        return FilamentNotification::make()
            ->success()
            ->title($notificationTitle)
            ->body($notificationBody)
            ->getDatabaseMessage();
    }
}
