<?php
namespace Adfox\Appearance\Filament\Pages;

use App\Filament\Clusters\DesignAppearance;
use App\Settings\AdListSettings;
use Filament\Forms;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;

class ManageAdList extends SettingsPage
{
    protected static string $settings = AdListSettings::class;
    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-squares-2x2';

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_ad_list_settings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_ad_list_settings');
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageAdList');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make(__('messages.t_ap_ad_list_sorting'))
                    ->description(__('messages.t_ap_customize_ad_list_sorting'))
                    ->schema([
                        Select::make('sort_by_position')
                            ->label(__('messages.t_ap_sort_by_position'))
                            ->options([
                                'filter_box'=> __('messages.t_ap_inside_filter_box'),
                                'above_ad_list'=> __('messages.t_ap_above_ad_list'),
                            ])
                            ->helperText(__('messages.t_ap_sort_by_position_helper'))
                            ->required(),
                    ])
                    ->collapsible(),

            ]);
    }
}
