<?php

namespace Adfox\Appearance\Filament\Pages;

use Adfox\Appearance\Enums\HomePageSectionType;
use App\Filament\Clusters\DesignAppearance;
use App\Models\Category;
use App\Settings\HomeSettings;
use Filament\Forms;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;

class ManageHome extends SettingsPage
{
    protected static string $settings = HomeSettings::class;

    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-home';

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_home_settings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_home_settings');
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageHome');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make(__('messages.t_ap_home_page_sections_order'))
                    ->description(__('messages.t_ap_customize_home_page_sections_order'))
                    ->schema([
                        Repeater::make('section_data')
                            ->addable(false)
                            ->disableLabel()
                            ->extraAttributes(['class' => 'hide-repeater-item-content'])
                            ->reorderableWithButtons()
                            ->deletable(false)
                            ->schema([
                                // TextInput::make('title')
                            ])
                            ->itemLabel(fn(array $state): ?string => HomePageSectionType::getLabel($state['type']) ?? null),
                    ]),

                Section::make(__('messages.t_ap_popular_ads_section'))
                    ->schema([
                        Select::make('displayed_popular_categories')
                            ->multiple()
                            ->label(__('messages.t_ap_popular_categories'))
                            ->placeholder(__('messages.t_ap_select_categories'))
                            ->options(Category::whereNull('parent_id')->pluck('name', 'id'))
                            ->helperText(__('messages.t_ap_popular_categories_helper')),
                    ])
                    ->collapsible(), // Makes the section collapsible
                Section::make(__('messages.t_ap_header_section_spacing'))
                    ->description(__('messages.t_ap_customize_header_section_spacing'))
                    ->collapsible()
                    ->columns(2)
                    ->schema([
                        TextInput::make('header_top_spacing')->numeric()->required()
                            ->helperText(__('messages.t_ap_set_top_spacing')),
                        TextInput::make('header_between_line_spacing')->numeric()->required()
                            ->helperText(__('messages.t_ap_set_between_line_spacing')),
                        TextInput::make('header_bottom_spacing')->numeric()->required()
                            ->helperText(__('messages.t_ap_set_bottom_spacing')),
                    ]),

                Section::make(__('messages.t_ap_all_categories_settings'))
                    ->description(__('messages.t_ap_customize_all_categories_appearance'))
                    ->collapsible()
                    ->columns(2)
                    ->schema([
                        Toggle::make('show_all_category')
                            ->label(__('messages.t_ap_show_all_categories_button'))
                            ->helperText(__('messages.t_ap_enable_disable_all_categories_button'))
                            ->required(),

                        TextInput::make('all_category_font_size')
                            ->label(__('messages.t_ap_all_categories_font_size'))
                            ->numeric()
                            ->required()
                            ->helperText(__('messages.t_ap_set_all_categories_font_size')),

                        Toggle::make('enable_hover_animation')
                            ->label(__('messages.t_ap_enable_hover_animation'))
                            ->helperText(__('messages.t_ap_enable_hover_animation_helper_text'))
                            ->required(),
                    ]),

                TextInput::make('search_box_size')
                    ->label(__('messages.t_ap_search_box_size_above_1024px'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_search_box_size_above_1024px_helper')),

                TextInput::make('lg_search_box_size')
                    ->label(__('messages.t_ap_search_box_size_above_1280px'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_search_box_size_above_1280px_helper')),
                Toggle::make('ad_type_dropdown_enable')
                    ->label(__('messages.t_enable_ad_type_dropdown'))
                    ->helperText(__('messages.t_enable_ad_type_dropdown_helper_text'))
            ]);
    }
}
