<div>
    <div>
        @if(isset($payment_gateway_params['order_id']))
        <div id="paypal-button-container" wire:ignore></div>
        @endif
    </div>

    @assets
    <script src="https://www.paypal.com/sdk/js?client-id={{ $this->paypalSettings?->client_id }}&currency={{ $this->paypalSettings?->currency }}"></script>
    @endassets

    @script
    <script>
        setTimeout(function() {
            // Render the PayPal button into #paypal-button-container
            paypal.Buttons({

                // Set up the transaction
                createOrder: function(data, actions) {
                    return actions.order.create({
                        purchase_units: [{
                            invoice_id: "{{ $payment_gateway_params['order_id'] }}",
                            amount: {
                                value: "{{ convertToNumber( number_format( $totalAmount * $this->paypalSettings?->exchange_rate / $this->paymentSettings?->exchange_rate, 2, '.', '' ) ) }}"
                            }
                        }]
                    });
                },

                // Finalize the transaction
                onApprove: function(data, actions) {
                    window.location.href = "{{ route('reservation.payment-callback.paypal', session()->get('current_temporary_order')) }}" + "?order=" + data.orderID;
                }

            }).render('#paypal-button-container');
        }, 0);
    </script>
    @endscript
</div>