<?php

namespace Adfox\ECommerce\Filament\App\Resources;

use Adfox\ECommerce\Filament\App\Resources\ReturnPolicyResource\Pages;
use Adfox\ECommerce\Models\ReturnPolicy;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class ReturnPolicyResource extends Resource
{
    protected static ?string $model = ReturnPolicy::class;

    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_ecommerce_navigation');
    }

    public static function isDiscovered(): bool
    {
        return is_ecommerce_active();
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('policy_name')
                    ->required()
                    ->maxLength(255)
                    ->label('Policy Name'),

                Textarea::make('description')
                    ->required()
                    ->maxLength(1000)
                    ->label('Description'),

                    TextInput::make('duration')
                    ->label('Duration (in days)')
                    ->minValue(1)
                    ->maxValue(365)
                    ->numeric()
                    ->nullable(),

                Textarea::make('exceptions')
                    ->label('Exceptions')
                    ->nullable(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->emptyStateIcon('/images/not-found.svg')
            ->modifyQueryUsing(fn(Builder $query) => $query->where('user_id', auth()->id()))
            ->columns([
                TextColumn::make('policy_name')
                    ->label('Policy Name')
                    ->sortable()
                    ->searchable(),

                TextColumn::make('description')
                    ->label('Description')
                    ->limit(30) // Limits the text shown in the table
                    ->sortable()
                    ->searchable(),

                TextColumn::make('duration')
                    ->label('Duration (in days)')
                    ->sortable()
                    ->searchable(),

                TextColumn::make('exceptions')
                    ->label('Exceptions')
                    ->limit(30) // Limits the text shown in the table
                    ->sortable()
                    ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\ViewAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReturnPolicies::route('/'),
            'create' => Pages\CreateReturnPolicy::route('/create'),
            'edit' => Pages\EditReturnPolicy::route('/{record}/edit'),
        ];
    }
}
