<?php

namespace Adfox\ECommerce\Models;

use App\Models\Ad;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Inventory extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'quantity_in_stock',
        'reorder_level',
        'last_updated',
        'warehouse_id',
        'ad_id',
        'user_id',
    ];

    public function ad()
    {
        return $this->belongsTo(Ad::class, 'ad_id', 'id');
    }
}
